/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "cfg.h"
#include "cfg-internal.h"


static void
load_callback (void *callback_data, char *element, char *key, char *value)
{
  _LW6CFG_CONTEXT *context;

  context = (_LW6CFG_CONTEXT *) callback_data;

  if (!strcmp (element, "option"))
    {
      lw6sys_assoc_set (&(context->options), key, lw6sys_str_copy (value));
    }
}

int
_lw6cfg_load (_LW6CFG_CONTEXT * context, char *filename)
{
  int ret = 0;

  if (lw6sys_file_exists (filename))
    {
      lw6sys_log (LW6SYS_LOG_INFO, "cfg", _("loading config from \"%s\""),
		  filename);


      ret =
	lw6cfg_read_key_value_xml_file (filename, load_callback,
					(void *) context);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_INFO, "cfg", _("ignoring config file \"%s\""),
		  filename);
    }

  return ret;
}

int
lw6cfg_load (void *context, char *filename)
{
  return _lw6cfg_load ((_LW6CFG_CONTEXT *) context, filename);
}
