;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;
;of the License, or (at your option) any later version.
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

; returns map-source
(define (lw6-load-map path)
  (let (
	(the-map (c-lw6map-read path))
	)
    (list
     (cons "path" path)
     (cons "map" the-map)
     (cons "background-style" (c-lw6map-get-background-style the-map))
     (cons "hud-style" (c-lw6map-get-hud-style the-map))
     (cons "menu-style" (c-lw6map-get-menu-style the-map))
     (cons "view-style" (c-lw6map-get-view-style the-map))
     )
    )
  )

; returns game-instance
(define (lw6-prepare-map map-source)
  (let* (
	 (game-struct (c-lw6ker-build-game-struct (assoc-ref map-source "map")))
	 (game-state (c-lw6ker-build-game-state game-struct))
	 )
    (append map-source (list
			(cons "game-struct" game-struct)
			(cons "game-state" game-state)
			(cons "game-look" (c-lw6gfx-default-game-look))
			(cons "moves-per-tick" 
			      (/ (* (c-lw6opt-static-get-int 
				     game-struct 
				     "moves-per-round")
				    (c-lw6opt-static-get-int 
				     game-struct 
				     "rounds-per-sec")
				    ) 1000))
			)
	    )
    )
  )

(define lw6-load-chosen-map
  (lambda ()
    (let (
	  (chosen-map-source (lw6-load-map (lw6-config-get-string "chosen-map")))
	  )
      (begin    
	(lw6-set-game-global! "chosen-map-source" chosen-map-source)
	(lw6-update-map-source-from-chosen)
	)
      )
    )
  )
      
(define lw6-update-map-source-from-chosen
  (lambda ()
    (lw6-set-game-global! "map-source" (list-copy (lw6-get-game-global "chosen-map-source")))
    )
  )