;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-display-background
  (lambda ()
    (let* (
	   (map-source (lw6-get-game-global "map-source"))
	   (last-background-style (lw6-get-game-global "last-background-style"))
	   (background-style 
	    (if map-source
		(assoc-ref map-source "background-style")
		(if last-background-style
		    last-background-style
		    (lw6-config-get-string "background-style")
		    )
		)
	    )
	   )
      (begin
	(c-lw6gfx-display-background background-style)
	(lw6-set-game-global! "last-background-style" background-style)
	)
      )
    )
  )

(define lw6-display-map
  (lambda ()
    (let (
	  (map-source (lw6-get-game-global "map-source"))
	  (game-instance (lw6-get-game-global "game-instance"))
	  )
      (if game-instance
	  (c-lw6gfx-display-game (assoc-ref game-instance "map")
				 (assoc-ref game-instance "game-state") 
				 (assoc-ref game-instance "game-look") 
				 (assoc-ref game-instance "view-style"))
	  (if map-source
	      (begin
		(c-lw6gfx-display-map-preview (assoc-ref map-source "map") (assoc-ref map-source "view-style"))
		)
	      )
	  )
      )
    )
  )

(define lw6-display-hud
  (lambda (step)
    (let (
	  (map-source (lw6-get-game-global "map-source"))
	  (game-instance (lw6-get-game-global "game-instance"))
	  )
      (if game-instance
	  (let(
	       (game-state (assoc-ref game-instance "game-state"))
	       (hud-style (assoc-ref game-instance "hud-style"))
	       )
	    (c-lw6gfx-display-hud game-state step hud-style)
	    )
	  (if map-source
	      (let (
		    (hud-style (assoc-ref map-source "hud-style"))
		    )
		  (c-lw6gfx-display-hud-preview step hud-style)
		)
	      )
	  )
      )
    )
  )

(define lw6-display-menu
  (lambda ()
    (if (not (lw6-empty-menu?))
	(let (
	      (map-source (lw6-get-game-global "map-source"))
	      )
	  (c-lw6gfx-display-menu
	   (lw6-current-menu)
	   (if map-source
	       (assoc-ref map-source "menu-style")
	       (lw6-config-get-string "menu-style")
	       )
	   )
	  )
	)
    )
  )

(define lw6-display-idle
  (lambda () 
    (begin  
      (c-lw6gfx-prepare-buffer)
      (lw6-display-background)
      (lw6-display-menu)
;      (c-lw6gfx-display-sysinfo %lw6-frames-per-sec %lw6-rounds-per-sec 0 0)
;      (c-lw6gfx-display-log (list 
;			     (_ "this is where") 
;			     (_ "messages") 
;			     (_ "could be logged")
;			     ))
;      (c-lw6gfx-display-time (c-lw6sys-timestamp))
      (c-lw6gfx-display-version)
      (c-lw6gfx-swap-buffers)
      )
    )
  )

(define lw6-display-game
  (lambda () 
    (begin  
      (c-lw6gfx-prepare-buffer)
      (lw6-display-background)
      (lw6-display-hud 0)
      (lw6-display-map)
      (lw6-display-hud 1)
      (lw6-display-menu)
      (c-lw6gfx-display-sysinfo %lw6-frames-per-sec %lw6-rounds-per-sec 0 0)
      (c-lw6gfx-display-log (list 
			     (_ "this is where") 
			     (_ "messages") 
			     (_ "could be logged")
			     ))
      (c-lw6gfx-display-time (c-lw6sys-timestamp))
      (c-lw6gfx-display-version)
      (c-lw6gfx-swap-buffers)
      )
    )
  )

(define lw6-display
  (lambda ()
    (let (
	  (display-func (lw6-get-game-global "display-func"))
	  )
      (if display-func
	  (display-func)
	  )
      )
    )
  )


