/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SYS_H
#define LIQUIDWAR6SYS_H

#include "../lw6-common.h"

#include "sys-types.h"

#define LW6SYS_SIZEOF_INT32 4
#define LW6SYS_SIZEOF_INT16 2

typedef struct LW6SYS_ASSOC_STRUCT
{
  char *key;
  void *value;
  void (*free_func) (void *value);
  void *next_item;		// LW6SYS_ASSOC *
}
LW6SYS_ASSOC;

typedef struct LW6SYS_LIST_STRUCT
{
  void *data;
  void (*free_func) (void *data);
  void *next_item;		// LW6SYS_LIST *
}
LW6SYS_LIST;

extern LW6SYS_COLOR_F LW6SYS_COLOR_F_WHITE;
extern LW6SYS_COLOR_F LW6SYS_COLOR_F_BLACK;
extern LW6SYS_COLOR_8 LW6SYS_COLOR_8_WHITE;
extern LW6SYS_COLOR_8 LW6SYS_COLOR_8_BLACK;

/*
 * Usefull macros for lw6sys_log, please do not use
 * lw6sys_log directly, but use constructs like
 * lw6sys_log(LW6SYS_LOG_<LEVEL>,"module","%s%d",str,num);
 */
#define LW6SYS_LOG_DEBUG_ID -1
#define LW6SYS_LOG_INFO_ID 0
#define LW6SYS_LOG_NOTICE_ID 1
#define LW6SYS_LOG_WARNING_ID 2
#define LW6SYS_LOG_ERROR_ID 3
#define LW6SYS_LOG_DEBUG LW6SYS_LOG_DEBUG_ID, __FILE__, __LINE__
#define LW6SYS_LOG_INFO LW6SYS_LOG_INFO_ID, __FILE__, __LINE__
#define LW6SYS_LOG_NOTICE LW6SYS_LOG_NOTICE_ID, __FILE__, __LINE__
#define LW6SYS_LOG_WARNING LW6SYS_LOG_WARNING_ID, __FILE__, __LINE__
#define LW6SYS_LOG_ERROR LW6SYS_LOG_ERROR_ID, __FILE__, __LINE__

/*
 * Functions in assoc.c
 */
extern LW6SYS_ASSOC *lw6sys_assoc_new (void (*free_func) (void *value));
extern void lw6sys_assoc_free (LW6SYS_ASSOC * assoc);
extern int lw6sys_assoc_has_key (LW6SYS_ASSOC * assoc, char *key);
extern void *lw6sys_assoc_get (LW6SYS_ASSOC * assoc, char *key);
extern void lw6sys_assoc_set (LW6SYS_ASSOC ** assoc, char *key, void *value);
extern void lw6sys_assoc_unset (LW6SYS_ASSOC * assoc, char *key);
extern LW6SYS_LIST *lw6sys_assoc_keys (LW6SYS_ASSOC * assoc);
extern void lw6sys_assoc_map (LW6SYS_ASSOC * assoc,
			      void (*func) (void *func_data, char *key,
					    void *value), void *func_data);

/*
 * Functions in checksum.c
 */
extern LW6SYS_UINT32 lw6sys_checksum (unsigned char *data, int len);
extern LW6SYS_UINT32 lw6sys_checksum_int32 (LW6SYS_UINT32 value);
extern LW6SYS_UINT32 lw6sys_checksum_wh (LW6SYS_WH * wh);
extern LW6SYS_UINT32 lw6sys_checksum_xy (LW6SYS_XY * xy);
extern void lw6sys_checksum_update (LW6SYS_UINT32 * checksum,
				    unsigned char *data, int len);
extern void lw6sys_checksum_update_int32 (LW6SYS_UINT32 * checksum,
					  LW6SYS_INT32 value);
extern void lw6sys_checksum_update_wh (LW6SYS_UINT32 * checksum,
				       LW6SYS_WH * wh);
extern void lw6sys_checksum_update_xy (LW6SYS_UINT32 * checksum,
				       LW6SYS_XY * xy);

/*
 * In color.c
 */
extern LW6SYS_UINT8 lw6sys_color_float2char (float comp);
extern float lw6sys_color_char2float (LW6SYS_UINT8 comp);
extern LW6SYS_COLOR_8 lw6sys_color_f_to_8 (LW6SYS_COLOR_F * color_f);
extern void lw6sys_color_8_to_f (LW6SYS_COLOR_F *
				 color_f, LW6SYS_COLOR_8 color_8);
extern LW6SYS_UINT32 lw6sys_color_f_to_i (LW6SYS_COLOR_F * color_f);
extern LW6SYS_UINT32 lw6sys_color_8_to_i (LW6SYS_COLOR_8 color_8);
extern void lw6sys_color_i_to_f (LW6SYS_COLOR_F * color_f,
				 LW6SYS_UINT32 color_i);
extern LW6SYS_COLOR_8 lw6sys_color_i_to_8 (LW6SYS_UINT32 color_i);
extern LW6SYS_COLOR_8 lw6sys_color_a_to_8 (char *ascii);
extern void lw6sys_color_a_to_f (LW6SYS_COLOR_F * color_f, char *ascii);

/*
 * Functions in convert.c
 */
extern int lw6sys_str2int (char *str);
extern char *lw6sys_int2str (int n);
extern int lw6sys_str2bool (char *str);
extern char *lw6sys_bool2str (int b);

/*
 * Functions in file.c
 */
extern char *lw6sys_read_file_content (char *filename);

/*
 * Functions in i18n.c
 */
extern char *lw6sys_locale_to_utf8 (char *string);

/*
 * Functions in list.c
 */
extern LW6SYS_LIST *lw6sys_list_new (void (*free_func) (void *data));
extern void lw6sys_list_free (LW6SYS_LIST * list);
extern LW6SYS_LIST *lw6sys_list_next (LW6SYS_LIST * list);
extern int lw6sys_list_is_empty (LW6SYS_LIST * list);
extern int lw6sys_list_length (LW6SYS_LIST * list);
extern void lw6sys_list_push (LW6SYS_LIST ** list, void *data);
extern void *lw6sys_list_pop (LW6SYS_LIST ** list);
extern void lw6sys_list_map (LW6SYS_LIST * list,
			     void (*func) (void *func_data, void *data),
			     void *func_data);

/*
 * Functions in log.c
 */
extern char *lw6sys_log_get_default_file ();
extern void lw6sys_log_clear ();
extern void lw6sys_log (int level_id, char *file, int line, char *module,
			char *fmt, ...);

/*
 * Functions in mem.c
 */
#define LW6SYS_MALLOC(SIZE) lw6sys_malloc((SIZE),__FILE__,__LINE__);
#define LW6SYS_CALLOC(SIZE) lw6sys_calloc((SIZE),__FILE__,__LINE__);
#define LW6SYS_FREE(PTR) lw6sys_free((PTR),__FILE__,__LINE__);

extern void *lw6sys_malloc (int size, char *file, int line);
extern void *lw6sys_calloc (int size, char *file, int line);
extern void lw6sys_free (void *ptr, char *file, int line);
extern void lw6sys_free_callback (void *ptr);
extern int lw6sys_get_malloc_count ();
extern int lw6sys_get_free_count ();
extern int lw6sys_check_malloc_free_count ();

/*
 * Functions in path.c
 */
extern int lw6sys_file_exists (char *filename);
extern int lw6sys_dir_exists (char *dirname);
extern int lw6sys_create_dir (char *dirname);
extern int lw6sys_create_dir_for_file (char *filename);
extern char *lw6sys_find_data_file (char *filename);

/*
 * Functions in sdl.c
 */
extern int lw6sys_sdl_register ();
extern int lw6sys_sdl_unregister ();

/*
 * Functions in serial.c
 */
extern void lw6sys_serialize_int32 (unsigned char *data, LW6SYS_INT32 value);
extern LW6SYS_UINT32 lw6sys_unserialize_int32 (unsigned char *data);
extern void lw6sys_serialize_int16 (unsigned char *data, LW6SYS_INT16 value);
extern LW6SYS_UINT16 lw6sys_unserialize_int16 (unsigned char *data);

/*
 * Functions in str.c
 */
extern char *lw6sys_str_copy (char *src);
extern char *lw6sys_str_concat (char *str1, char *str2);
extern char *lw6sys_new_sprintf (char *fmt, ...);

/*
 * Functions in time.c
 */
extern long long lw6sys_timestamp ();
extern void lw6sys_sleep (float seconds);

/*
 * Various inline utils
 */
static inline int
lw6sys_min (int a, int b)
{
  return (a < b) ? a : b;
}
static inline int
lw6sys_max (int a, int b)
{
  return (a > b) ? a : b;
}

#endif
