/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <locale.h>
#include <langinfo.h>

#include "config.h"
#include "sys.h"

/*
 * Used to force strings into UTF8 mode, this is basically
 * to match the TTF font settings used when displaying stuff
 * on OpenGL. String must be freed.
 */
char *
lw6sys_locale_to_utf8 (char *string)
{
  char *codeset;
  iconv_t cd;
  char *utf8 = NULL;

  codeset = nl_langinfo (CODESET);
  if (!codeset)
    {
      codeset = "ISO-8859-1";
    }

  /*
   * Note: we could also test here if we are already
   * in UTF-8 mode to avoid translating from UTF-8 to UTF-8,
   * not sure it would make a big difference anyway.
   */
  if (codeset)
    {
      cd = iconv_open ("UTF-8", codeset);

      if (cd != (iconv_t) - 1)
	{
	  int ilen;
	  int max_olen;
	  char *iptr;
	  size_t ileft;
	  char *optr;
	  size_t oleft;

	  ilen = strlen (string);
	  max_olen = strlen (string) * 2;

	  utf8 = LW6SYS_MALLOC (max_olen + 1);
	  if (utf8)
	    {
	      memset (utf8, 0, max_olen + 1);

	      iptr = string;
	      ileft = ilen;
	      optr = utf8;
	      oleft = max_olen;

	      if (iconv (cd, &iptr, &ileft, &optr, &oleft) == (size_t) - 1)
		{
		  lw6sys_log (LW6SYS_LOG_WARNING, "sys", "iconv error \"%s\"",
			      string);
		}
	    }
	  iconv_close (cd);
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "sys", "unable to open iconv");
	}
    }

  if (utf8 == NULL)
    {
      int length = strlen (string);
      utf8 = LW6SYS_MALLOC (length + 1);
      if (utf8 != NULL)
	{
	  strncpy (utf8, string, length + 1);
	  utf8[length] = '\0';
	}
    }

  if (utf8 == NULL)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  "unable to translate string to utf8");
    }

  return utf8;
}
