/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "sys.h"

/*
 * Read all the contents of a file, put it in a dynamically
 * allocated string. You need to free the pointer afterwards.
 */
char *
lw6sys_read_file_content (char *filename)
{
  char *file_content = NULL;
  FILE *f;
  int size;
  size_t read = 0;

  f = fopen (filename, "r");
  if (f)
    {
      fseek (f, 0, SEEK_END);
      size = ftell (f);
      if (size >= 0)
	{
	  fseek (f, 0, SEEK_SET);
	  file_content = LW6SYS_MALLOC (size + 1);
	  /*
	   * Do not suppress this memset 0, it's responsible for
	   * putting a traling '\0'. Doing a simple affectation on
	   * the last byte would work to, but this is even safer,
	   * this way even if we half read the file, the non-read
	   * stuff will be filled with zeros.
	   */
	  memset (file_content, 0, size + 1);
	  if (file_content)
	    {
	      clearerr (f);
	      while ((!feof (f)) && (!ferror (f)))
		{
		  read += fread (file_content + read, sizeof (char), size, f);
		}
	      if (read != size)
		{
		  lw6sys_log (LW6SYS_LOG_WARNING, "sys",
			      _
			      ("couldn't read all of file \"%s\", size was supposed to be %d but only read %d"),
			      filename, size, read);
		}
	    }
	}
      fclose (f);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("can't open file \"%s\" for reading"), filename);
    }

  return file_content;
}
