/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "snd.h"

LW6SYS_ASSOC *
lw6snd_get_backends ()
{
  LW6SYS_ASSOC *ret = NULL;
  char *path;

  ret = lw6sys_assoc_new (NULL);
  if (ret)
    {
      path = lw6dyn_path_find_backend ("snd", "ogg");
      if (path)
	{
	  lw6sys_assoc_set (&ret, "ogg", (void *) _("Ogg Vorbis"));
	  LW6SYS_FREE (path);
	}
      path = lw6dyn_path_find_backend ("snd", "csound");
      if (path)
	{
	  lw6sys_assoc_set (&ret, "csound", (void *) _("Csound"));
	  LW6SYS_FREE (path);
	}
    }

  return ret;
}

LW6SND_BACKEND *
lw6snd_create_backend (char *name)
{
  LW6SND_BACKEND *backend = NULL;
  LW6DYN_DL_HANDLE *backend_handle = NULL;

  backend_handle = lw6dyn_dlopen_backend ("snd", name);

  if (backend_handle)
    {
      char *init_func_name;
      LW6SND_BACKEND *(*init_func) ();

      init_func_name = lw6sys_new_sprintf ("mod_%s_create_backend", name);
      if (init_func_name)
	{
	  init_func = lw6dyn_dlsym (backend_handle, init_func_name);
	  if (init_func)
	    {
	      backend = init_func ();
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING, "snd",
			  _
			  ("unable to find function \"%s\" in sound backend \"%s\""),
			  init_func_name, name);
	    }

	  LW6SYS_FREE (init_func_name);
	}
    }


  if (backend && backend_handle)
    {
      backend->dl_handle = backend_handle;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "snd",
		  _("unable to open sound backend \"%s\""), name);
    }

  return backend;
}

void
lw6snd_destroy_backend (LW6SND_BACKEND * backend)
{
  lw6dyn_dlclose_backend (backend->dl_handle);
  LW6SYS_FREE (backend);
}
