/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "snd.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING, "snd",
	      _("snd backend function \"%s\" is not defined"), func_name);
}

int
lw6snd_play_sound (LW6SND_BACKEND * backend, int sound_id)
{
  int ret = 0;

  if (backend->play_sound)
    {
      ret = backend->play_sound (backend->snd_context, sound_id);
    }
  else
    {
      warning ("play_sound");
    }

  return ret;
}

int
lw6snd_play_music (LW6SND_BACKEND * backend, char *music_name)
{
  int ret = 0;

  if (backend->play_music)
    {
      ret = backend->play_music (backend->snd_context, music_name);
    }
  else
    {
      warning ("play_music");
    }

  return ret;
}

int
lw6snd_init (LW6SND_BACKEND * backend, float sound_volume, float music_volume)
{
  if (backend->init)
    {
      backend->snd_context = backend->init (sound_volume, music_volume);
    }
  else
    {
      warning ("init");
    }

  return backend->snd_context ? 1 : 0;
}

void
lw6snd_set_sound_volume (LW6SND_BACKEND * backend, float volume)
{
  if (backend->set_sound_volume)
    {
      backend->set_sound_volume (backend->snd_context, volume);
    }
  else
    {
      warning ("set_sound_volume");
    }
}

void
lw6snd_set_music_volume (LW6SND_BACKEND * backend, float volume)
{
  if (backend->set_music_volume)
    {
      backend->set_music_volume (backend->snd_context, volume);
    }
  else
    {
      warning ("set_music_volume");
    }
}

void
lw6snd_quit (LW6SND_BACKEND * backend)
{
  if (backend->quit)
    {
      backend->quit (backend->snd_context);
      backend->snd_context = NULL;
    }
  else
    {
      warning ("quit");
    }
}
