/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "../snd.h"
#include "mod-ogg-internal.h"

_MOD_OGG_CONTEXT *
_mod_ogg_init (float sound_volume, float music_volume)
{
  _MOD_OGG_CONTEXT *snd_context = NULL;
  int sdl_ok = 1;

  snd_context =
    (_MOD_OGG_CONTEXT *) LW6SYS_CALLOC (sizeof (_MOD_OGG_CONTEXT));
  if (snd_context)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "snd-mod-ogg",
		  _("ogg init volume=%01.2f/%01.2f"), sound_volume,
		  music_volume);

      _mod_ogg_load_consts (snd_context);

      if (lw6sys_sdl_register ())
	{
	  sdl_ok = !SDL_Init (0);
	}

      sdl_ok = sdl_ok && (SDL_WasInit (SDL_INIT_TIMER)
			  || !SDL_InitSubSystem (SDL_INIT_TIMER));
      sdl_ok = sdl_ok && (SDL_WasInit (SDL_INIT_AUDIO)
			  || !SDL_InitSubSystem (SDL_INIT_AUDIO));

      if (sdl_ok)
	{
	  if (!Mix_OpenAudio
	      (snd_context->const_data.frequency,
	       (snd_context->const_data.bits == 8) ? AUDIO_U8 : AUDIO_S16SYS,
	       snd_context->const_data.channels,
	       snd_context->const_data.chunksize))
	    {
	      _mod_ogg_set_sound_volume (snd_context, sound_volume);
	      _mod_ogg_set_music_volume (snd_context, music_volume);
	      _mod_ogg_load_sounds (snd_context);
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING, "snd-mod-ogg",
			  _("SDL_mixer init error: \"%s\""), Mix_GetError ());
	    }
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "snd-mod-ogg",
		      _("SDL init error: \"%s\""), SDL_GetError ());
	}
    }

  return snd_context;
}

void
_mod_ogg_quit (_MOD_OGG_CONTEXT * snd_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, "snd-mod-ogg", _("ogg quit"));

  Mix_CloseAudio ();

  _mod_ogg_unload_sounds (snd_context);

  SDL_QuitSubSystem (SDL_INIT_AUDIO);
  SDL_QuitSubSystem (SDL_INIT_TIMER);

  if (lw6sys_sdl_unregister ())
    {
      lw6sys_log (LW6SYS_LOG_INFO, "snd-mod-ogg", _("SDL Quit"));
      SDL_Quit ();
    }

  LW6SYS_FREE (snd_context);
}
