/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SND_OGG_INTERNAL_H
#define LIQUIDWAR6SND_OGG_INTERNAL_H

#include "../snd.h"

#include <SDL/SDL.h>
#include <SDL/SDL_mixer.h>

typedef struct _MOD_OGG_VOLUME_STRUCT
{
  float sound_volume;
  float music_volume;
}
_MOD_OGG_VOLUME;

typedef struct _MOD_OGG_CONST_DATA_STRUCT
{
  int frequency;
  int bits;
  int channels;
  int chunksize;
}
_MOD_OGG_CONST_DATA;

typedef struct _MOD_OGG_SOUNDS_STRUCT
{
  Mix_Chunk *sounds[LW6SND_NB_SOUNDS];
}
_MOD_OGG_SOUNDS;

typedef struct _MOD_OGG_CONTEXT_STRUCT
{
  _MOD_OGG_VOLUME volume;
  _MOD_OGG_CONST_DATA const_data;
  _MOD_OGG_SOUNDS sounds;
}
_MOD_OGG_CONTEXT;

/*
 * In const.c
 */
extern int _mod_ogg_load_consts (_MOD_OGG_CONTEXT * context);
extern void _mod_ogg_unload_consts (_MOD_OGG_CONTEXT * context);

/*
 * In sound.c
 */
extern int _mod_ogg_play_sound (_MOD_OGG_CONTEXT * snd_context, int sound_id);
extern int _mod_ogg_load_sounds (_MOD_OGG_CONTEXT * context);
extern void _mod_ogg_unload_sounds (_MOD_OGG_CONTEXT * context);

/*
 * In music.c
 */
extern int _mod_ogg_play_music (_MOD_OGG_CONTEXT * snd_context,
				char *music_name);

/*
 * In setup.c
 */
extern _MOD_OGG_CONTEXT *_mod_ogg_init (float sound_volume,
					float music_volume);
extern void _mod_ogg_quit (_MOD_OGG_CONTEXT * snd_context);

/*
 * In volume.c
 */
extern void _mod_ogg_set_sound_volume (_MOD_OGG_CONTEXT * snd_context,
				       float volume);
extern void _mod_ogg_set_music_volume (_MOD_OGG_CONTEXT * snd_context,
				       float volume);

#endif
