/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "../snd.h"
#include "mod-csound-internal.h"

_CSOUND_CONTEXT *
_mod_csound_init (float sound_volume, float music_volume)
{
  _CSOUND_CONTEXT *snd_context = NULL;

  snd_context = (_CSOUND_CONTEXT *) LW6SYS_CALLOC (sizeof (_CSOUND_CONTEXT));
  if (!snd_context)
    {
      /*
       * No use to continue if this basic malloc fails...
       */
      exit (1);
    }

  lw6sys_log (LW6SYS_LOG_INFO, "snd", _("csound init volume=%01.2f/%01.2f"),
	      sound_volume, music_volume);

  return snd_context;
}

void
_mod_csound_quit (_CSOUND_CONTEXT * snd_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, "snd", _("csound quit"));
  LW6SYS_FREE (snd_context);
}
