/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <libguile.h>
#include <GL/gl.h>
#include <SDL/SDL.h>

#include "liquidwar6.h"

static void
help ()
{
  printf
    (_("Usage: %s [option]...\n"
       "\n"
       "Basic options:\n"
       "\n"
       "--help       display this basic help and exit\n"
       "--copyright  display copyright information and exit\n"
       "--version    display version information and exit\n"
       "--fullscreen run the game in fullscreen mode\n"
       "\n"
       "You can read the documentation online on\n"
       "http://www.gnu.org/software/liquidwar6/manual/\n"
       "\n"
       "Report bugs to <bug-liquidwar6@gnu.org> or\n"
       "https://savannah.gnu.org/bugs/?func=additem&group=liquidwar6\n"),
     PACKAGE_TARNAME);
}

static void
copyright ()
{
  printf
    ("%s",
     "Liquid War 6 is a unique multiplayer wargame.\n"
     "Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>\n"
     "\n"
     "This program is free software; you can redistribute it and/or\n"
     "modify it under the terms of the GNU General Public License\n"
     "as published by the Free Software Foundation; either version 2\n"
     "of the License, or (at your option) any later version.\n"
     "\n"
     "This program is distributed in the hope that it will be useful,\n"
     "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
     "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
     "GNU General Public License for more details.\n"
     "\n"
     "You should have received a copy of the GNU General Public License\n"
     "along with this program; if not, write to the Free Software\n"
     "Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n");
}

static void
short_copyright ()
{
  printf (_("Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>\n"
	    "Released under the terms of the GNU General Public License (GPL)\n"));
}

static void
version (char *arg0)
{
  scm_init_guile ();

  printf (PACKAGE_TARNAME " (" PACKAGE_NAME ") " PACKAGE_VERSION "\n");
  short_copyright ();
}

static void
configure_args ()
{
  printf ("%s\n", LW6_CONFIGURE_ARGS);
}

static void
prefix ()
{
  printf ("%s\n", LW6_PREFIX);
}

static void
cflags ()
{
  printf
    ("-I%s -DLW6_PREFIX=\"%s\" -DLW6_LOCALE_DIR=\"%s\" -DLW6_SCRIPT_DIR=\"%s\" -DLW6_DATA_DIR=\"%s\" -DLW6_CONF_DIR=\"%s\" -DLW6_TOP_SRC_DIR=\"%s\"\n",
     LW6_INCLUDE_DIR, LW6_PREFIX, LW6_LOCALE_DIR, LW6_SCRIPT_DIR,
     LW6_DATA_DIR, LW6_CONF_DIR, LW6_TOP_SRC_DIR);
}

static void
welcome ()
{
  char *log_file;

  printf (_("%s, compiled %s\n"), PACKAGE_STRING, __DATE__);
  short_copyright ();

  log_file = lw6sys_log_get_default_file ();
  if (log_file)
    {
      printf (_("Log file is \"%s\"\n"), log_file);
      LW6SYS_FREE (log_file);
    }

  lw6sys_log_clear ();
  lw6sys_log (LW6SYS_LOG_INFO, "", _("program version is \"%s\""),
	      PACKAGE_VERSION);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("date/time of compilation is \"%s %s\""),
	      __DATE__, __TIME__);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("was compiled on host \"%s\""),
	      LW6_HOSTNAME);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("target CPU = \"%s\""), LW6_TARGET_CPU);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("configure_args = \"%s\""),
	      LW6_CONFIGURE_ARGS);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("prefix = \"%s\""), LW6_PREFIX);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("locale dir = \"%s\""), LW6_LOCALE_DIR);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("script dir = \"%s\""), LW6_SCRIPT_DIR);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("data dir = \"%s\""), LW6_DATA_DIR);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("conf dir = \"%s\""), LW6_CONF_DIR);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("include dir = \"%s\""),
	      LW6_INCLUDE_DIR);
  lw6sys_log (LW6SYS_LOG_INFO, "", _("top src dir = \"%s\""),
	      LW6_TOP_SRC_DIR);
}

int
lw6_process_basic_options (int argc, char *argv[])
{
  int i;
  int ret = 0;

  for (i = 1; i < argc; ++i)
    {
      if (strcasecmp (argv[i], "--help") == 0 ||
	  strcasecmp (argv[i], "-help") == 0 ||
	  strcasecmp (argv[i], "help") == 0 ||
	  strcasecmp (argv[i], "/help") == 0 ||
	  strcasecmp (argv[i], "-h") == 0 ||
	  strcasecmp (argv[i], "/h") == 0 ||
	  strcasecmp (argv[i], "-?") == 0 || strcasecmp (argv[i], "/?") == 0)
	{
	  help ();
	  ret = 1;
	}
      else if (strcasecmp (argv[i], "--copyright") == 0 ||
	       strcasecmp (argv[i], "-copyright") == 0 ||
	       strcasecmp (argv[i], "--copyleft") == 0 ||
	       strcasecmp (argv[i], "-copyleft") == 0 ||
	       strcasecmp (argv[i], "-c") == 0)
	{
	  copyright ();
	  ret = 1;
	}
      else if (strcasecmp (argv[i], "--version") == 0 ||
	       strcasecmp (argv[i], "-version") == 0 ||
	       strcasecmp (argv[i], "-v") == 0)
	{
	  version (argv[0]);
	  ret = 1;
	}
      else if (strcasecmp (argv[i], "--configure-args") == 0 ||
	       strcasecmp (argv[i], "-configure-args") == 0 ||
	       strcasecmp (argv[i], "--config") == 0 ||
	       strcasecmp (argv[i], "-config") == 0)
	{
	  configure_args ();
	  ret = 1;
	}
      else if (strcasecmp (argv[i], "--prefix") == 0 ||
	       strcasecmp (argv[i], "-prefix") == 0)
	{
	  prefix ();
	  ret = 1;
	}
      else if (strcasecmp (argv[i], "--cflags") == 0 ||
	       strcasecmp (argv[i], "-cflags") == 0)
	{
	  cflags ();
	  ret = 1;
	}
    }

  if (!ret)
    {
      welcome ();
    }

  return ret;
}
