/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6NET_H
#define LIQUIDWAR6NET_H

#include "../lw6-common.h"
#include "../sys/sys.h"

#define LW6NET_SERVER_LOOPBACK "127.0.0.1"
#define LW6NET_DEFAULT_SERVER_LAN "192.168.0.251"
#define LW6NET_DEFAULT_SERVER_WAN "ufoot.hd.free.fr"
#define LW6NET_DEFAULT_LIST "http://www.gnu.org/software/liquidwar6/list.txt"

#define LW6NET_DEFAULT_PORT 8056

/*
 * In socket.c
 */
extern int lw6net_socket_connect (char *host, int port);
extern void *lw6net_socket_async_connect_init (char *host, int port);
extern int lw6net_socket_async_connect_get (void *handler);
extern void lw6net_socket_async_connect_end (void *handler);
extern int lw6net_socket_send (int socket, char *buf, int len);
extern int lw6net_socket_send_str (int socket, char *str);
extern int lw6net_socket_peek (int socket, int len);
extern int lw6net_socket_recv (int socket, char *buf, int len);

#endif
