/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <locale.h>
#include <string.h>

#include "config.h"
#include "map.h"

#define TEST_MAP "alpha/genuine-liquidwar/"

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"map-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"map-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"map-test",_("tests in \"%s\" failed"),__FUNCTION__); }

/*
 * Testing map directory functions
 */
static int
test_dir ()
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    lw6sys_log (LW6SYS_LOG_DEBUG, "map-test", _("system dir is \"%s\""),
		lw6map_get_system_dir ());
  }

  FUNCTION_END;
  return ret;
}

/*
 * Testing basic new & free functions
 */
static int
test_new_free ()
{
  int ret = 1;
  LW6MAP_MAP *map;
  FUNCTION_BEGIN;

  {
    map = lw6map_new ();
    if (map == NULL)
      {
	ret = 0;
      }
  }
  {
    if (map)
      {
	lw6map_free (map);
      }
  }

  FUNCTION_END;
  return ret;
}

/*
 * Testing reading
 */
static int
test_read ()
{
  int ret = 1;
  LW6MAP_MAP *map;
  LW6MAP_PARAM param;
  char *repr;
  char *path;
  FUNCTION_BEGIN;

  path = lw6sys_str_concat (lw6map_get_system_dir (), TEST_MAP);
  if (path)
    {
      memset (&param, 0, sizeof (LW6MAP_PARAM));
      lw6map_param_defaults (&param);

      map = lw6map_read (path, &param);
      if (map)
	{
	  repr = lw6map_repr (map);
	  if (repr)
	    {
	      lw6sys_log (LW6SYS_LOG_DEBUG, "map-test",
			  _("after reading, map repr is \"%s\""), repr);
	      LW6SYS_FREE (repr);
	    }
	  else
	    {
	      ret = 0;
	    }
	  lw6map_free (map);
	}
      else
	{
	  ret = 0;
	}
      LW6SYS_FREE (path);
    }
  else
    {
      ret = 0;
    }

  FUNCTION_END;
  return ret;
}

int
main (int argc, char *argv[])
{
  int ret = 1;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  ret = test_dir () && test_new_free () && test_read ();

  ret = ret && lw6sys_check_malloc_free_count ();

  return (!ret);
}
