/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include <libpng/png.h>

#include "config.h"
#include "map.h"
#include "map-internal.h"

/*
 * Read the content of a directory.
 */
LW6MAP_MAP *
lw6map_read (char *dirname, LW6MAP_PARAM * param)
{
  LW6MAP_MAP *map = NULL;
  int ok = 0;

  lw6sys_log (LW6SYS_LOG_INFO, "map", _("loading map \"%s\""), dirname);

  map = lw6map_new ();
  if (map)
    {
      /*
       * This copy is very important, else nothing will work since
       * param_read supposes the structure already contains "correct"
       * default values.
       */
      lw6map_param_copy (&(map->param), param);

      if (lw6map_metadata_read (&map->metadata, dirname) &&
	  lw6map_param_read (&map->param, dirname) &&
	  lw6map_depth_read (&map->depth, dirname, &(map->param.options)) &&
	  lw6map_elevation_read (&map->elevation, dirname, &map->depth) &&
	  lw6map_texture_read (&map->texture, dirname, &map->depth,
			       &map->elevation))
	{
	  ok = 1;
	}
    }

  return map;
}
