/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6_H
#define LIQUIDWAR6_H

#include <pthread.h>
#include <libguile.h>

#include "config.h"
#include "lw6-common.h"
#include "sys/sys.h"
#include "dyn/dyn.h"
#include "con/con.h"
#include "cfg/cfg.h"
#include "opt/opt.h"
#include "map/map.h"
#include "ker/ker.h"
#include "gfx/gfx.h"
#include "snd/snd.h"
#include "net/net.h"

typedef struct LW6_SMOB_TYPES_STRUCT
{
  scm_t_bits map;
  scm_t_bits game_struct;
  scm_t_bits game_state;
  scm_t_bits game_look;
}
LW6_SMOB_TYPES;

typedef struct LW6_GLOBAL_STRUCT
{
  pthread_mutex_t mutex;
  void *cfg_context;
  LW6GFX_BACKEND *gfx_backend;
  LW6SND_BACKEND *snd_backend;
  int cfg_initialized;
  int gfx_initialized;
  int snd_initialized;
  int con_initialized;
  int argc;
  char **argv;
  LW6_SMOB_TYPES smob_types;
  LW6SYS_ASSOC *map_smobs;
  LW6SYS_ASSOC *game_struct_smobs;
  LW6SYS_ASSOC *game_state_smobs;
  LW6SYS_ASSOC *game_look_smobs;
}
LW6_GLOBAL;

/*
 * In global.c
 */
#define LW6_MUTEX_LOCK pthread_mutex_lock( &lw6_global.mutex );
#define LW6_MUTEX_UNLOCK pthread_mutex_unlock( &lw6_global.mutex );

extern LW6_GLOBAL lw6_global;
extern int lw6_init_global (int argc, char *argv[]);
extern void lw6_quit_global ();

/*
 * Functions in callback.c
 */
extern void lw6_resize_callback (int width, int height, int fullscreen);

/*
 * Functions in control.c
 */
extern void lw6_exit ();

/*
 * Functions in funcs.c
 */
extern int lw6_register_funcs ();
extern void lw6_con_handler (char *line);

/*
 * Functions in options.c
 */
extern int lw6_process_basic_options (int argc, char *argv[]);

/*
 * Functions in script.c
 */
extern char *lw6_find_script ();

/*
 * Functions in smobs.c
 */
extern LW6MAP_MAP *lw6_scm_to_map (SCM map);
extern SCM lw6_make_scm_map (LW6MAP_MAP * c_map);
extern LW6KER_GAME_STRUCT *lw6_scm_to_game_struct (SCM game_struct);
extern SCM lw6_make_scm_game_struct (LW6KER_GAME_STRUCT * c_game_struct);
extern LW6KER_GAME_STATE *lw6_scm_to_game_state (SCM game_state);
extern SCM lw6_make_scm_game_state (LW6KER_GAME_STATE * c_game_state);
extern LW6GFX_GAME_LOOK *lw6_scm_to_game_look (SCM game_look);
extern SCM lw6_make_scm_game_look (LW6GFX_GAME_LOOK * c_game_look);
extern int lw6_register_smobs ();

#endif
