/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include <libpng/png.h>

#include "config.h"
#include "ker.h"
#include "ker-internal.h"

/*
 * Create a dummy empty rectangle, mostly for testing purposes.
 */
LW6MAP_MAP *
lw6ker_map_new_rectangle (int width, int height)
{
  LW6MAP_MAP *map;

  map = (LW6MAP_MAP *) LW6SYS_CALLOC (sizeof (LW6MAP_MAP));

  if (map)
    {
      if (_lw6ker_map_metadata_rectangle (&map->metadata, width, height) &&
	  _lw6ker_map_depth_rectangle (&map->depth, width, height))
	{
	  /*
	   * param->style, elevation and texture can be left as is, they are
	   * initialized to 0 with map_new, and being null is OK for them.
	   */
	  lw6opt_static_defaults (&(map->param.options));
	}
      else
	{
	  lw6ker_map_free_rectangle (map);
	  map = NULL;
	}
    }

  return map;
}

/*
 * Frees a dummy empty rectangle map, won't work for complex map,
 * but OK for testing.
 */
void
lw6ker_map_free_rectangle (LW6MAP_MAP * map)
{
  LW6SYS_FREE (map->metadata.title);
  LW6SYS_FREE (map->metadata.readme);
  LW6SYS_FREE (map->depth.data);
  LW6SYS_FREE (map);
}

int
_lw6ker_map_metadata_rectangle (LW6MAP_METADATA * metadata, int width,
				int height)
{
  int ret = 0;

  metadata->title = lw6sys_new_sprintf ("rectangle-%dx%d", width, height);
  metadata->readme =
    lw6sys_new_sprintf (_("built-in rectangle map (%dx%d)"), width, height);

  ret = (metadata->title && metadata->readme);

  return ret;
}

int
_lw6ker_map_depth_rectangle (LW6MAP_DEPTH * depth, int width, int height)
{
  int ret = 0;
  int x, y;

  depth->shape.w = width;
  depth->shape.h = height;
  depth->data =
    (unsigned char *) LW6SYS_CALLOC (depth->shape.w * depth->shape.h *
				     sizeof (unsigned char *));

  if (depth->data)
    {
      for (y = 0; y < depth->shape.h; ++y)
	{
	  for (x = 0; x < depth->shape.w; ++x)
	    {
	      lw6map_depth_set (depth, x, y, 0);
	    }
	}

      for (y = 1; y < depth->shape.h - 1; ++y)
	{
	  for (x = 1; x < depth->shape.w - 1; ++x)
	    {
	      lw6map_depth_set (depth, x, y, 1);
	    }
	}
      ret = 1;
    }

  return ret;
}
