/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "config.h"
#include "ker.h"
#include "ker-internal.h"

LW6SYS_BOOL
_lw6ker_layer_init (LW6KER_LAYER * layer,
		    LW6KER_MAP_STRUCT * map_struct,
		    LW6KER_ARMIES * armies, LW6OPT_STATIC * options)
{
  LW6SYS_BOOL ret = 0;
  LW6SYS_INT32 i;

  layer->map_struct = map_struct;
  layer->armies = armies;

  layer->nb_slots = map_struct->shape.w * map_struct->shape.h;
  layer->slots =
    (LW6KER_SLOT_STATE *) LW6SYS_CALLOC (layer->nb_slots *
					 sizeof (LW6KER_SLOT_STATE));
  if (layer->slots)
    {
      ret = 1;

      for (i = 0; i < layer->nb_slots; ++i)
	{
	  layer->slots[i].fighter_id = -1;
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "ker",
		  _("unable to allocate SLOT_STATE array"));
    }

  return ret;
}

void
_lw6ker_layer_clear (LW6KER_LAYER * layer)
{
  if (layer->slots)
    {
      LW6SYS_FREE (layer->slots);
    }
  layer->slots = NULL;
  layer->nb_slots = 0;

  layer->armies = NULL;
  layer->map_struct = NULL;
}

LW6SYS_BOOL
_lw6ker_layer_copy (LW6KER_LAYER * dst, LW6KER_LAYER * src)
{
  LW6SYS_BOOL ret = 0;

  if (dst && src && dst->map_struct && src->map_struct
      && dst->map_struct == src->map_struct)
    {
      dst->nb_slots = src->nb_slots;
      memcpy (dst->slots, src->slots,
	      src->map_struct->nb_slots * sizeof (LW6KER_SLOT_STATE));
      /*
       * Note: we don't copy or even affect "armies" here, we rely on
       * the first initialization of the pointer, and the contents are
       * memcopied from armies_copy.
       */
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "ker",
		  _
		  ("layer_copy only works if dst and src point to the same map_struct"));
    }

  return ret;
}

void
_lw6ker_layer_update_checksum (LW6KER_LAYER * layer, LW6SYS_UINT32 * checksum)
{
  int i;
  // map_struct & armies checksumed elsewhere
  lw6sys_checksum_update_int32 (checksum, layer->nb_slots);
  for (i = 0; i < layer->nb_slots; ++i)
    {
      _lw6ker_slot_state_update_checksum (&(layer->slots[i]), checksum);
    }
}
