/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "liquidwar6.h"

/*
 * This structure holds all the global variables in LW6.
 * Why do we do this when we state everywhere we do *not*
 * want to use globals? Well, sometimes it just makes
 * sense to use globals. For instance argc and argv are
 * truely application-wide. Note that should we decide
 * to use no globals at all and pass everything as a
 * parameter, having it already in a struct is like
 * having done most of the job already...
 */
LW6_GLOBAL lw6_global;

/*
 * Initializes global values to their defaults
 */
int
lw6_init_global (int argc, char *argv[])
{
  int ret = 0;

  memset (&lw6_global, 0, sizeof (LW6_GLOBAL));

  pthread_mutex_init (&lw6_global.mutex, NULL);

  lw6_global.argc = argc;
  lw6_global.argv = argv;

  LW6_MUTEX_LOCK;

  ret =
    ((lw6_global.map_smobs =
      lw6sys_assoc_new ((void (*)(void *)) lw6map_free)) != NULL) &&
    ((lw6_global.game_struct_smobs =
      lw6sys_assoc_new ((void (*)(void *)) lw6ker_game_struct_free)) != NULL)
    && ((lw6_global.game_state_smobs =
	 lw6sys_assoc_new ((void (*)(void *)) lw6ker_game_state_free)) !=
	NULL)
    &&
    ((lw6_global.game_look_smobs =
      lw6sys_assoc_new ((void (*)(void *)) lw6gfx_game_look_free)) != NULL);

  LW6_MUTEX_UNLOCK;

  return ret;
}

static void
quit_cfg ()
{
  if (lw6_global.cfg_initialized && (lw6_global.cfg_context != NULL))
    {
      lw6cfg_quit (lw6_global.cfg_context);
    }
  lw6_global.cfg_context = NULL;
  lw6_global.cfg_initialized = 0;
}

static void
quit_gfx ()
{
  if (lw6_global.gfx_backend != NULL)
    {
      if (lw6_global.gfx_initialized)
	{
	  lw6gfx_quit (lw6_global.gfx_backend);
	}
      lw6gfx_destroy_backend (lw6_global.gfx_backend);
    }
  lw6_global.gfx_backend = NULL;
  lw6_global.gfx_initialized = 0;
}

static void
quit_snd ()
{
  if (lw6_global.snd_backend != NULL)
    {
      if (lw6_global.snd_initialized)
	{
	  lw6snd_quit (lw6_global.snd_backend);
	}
      lw6snd_destroy_backend (lw6_global.snd_backend);
    }
  lw6_global.snd_backend = NULL;
  lw6_global.snd_initialized = 0;
}

static void
quit_con ()
{
  if (lw6_global.con_initialized)
    {
      lw6con_handler_remove ();
    }
  lw6_global.con_initialized = 0;
}

void
lw6_quit_global ()
{
  /*
   * First, we free libraries. Note that this is normally
   * done in scripts, but... in some cases (especially when
   * a script is wrecked and/or crashes) it's not done.
   * In that case we do it manually, sort of double security.
   */
  lw6sys_log (LW6SYS_LOG_INFO, "", _("quit everything"));

  quit_con ();
  quit_snd ();
  quit_gfx ();
  quit_cfg ();

  lw6sys_log (LW6SYS_LOG_INFO, "", _("final garbage collection"));

  LW6_MUTEX_LOCK;

  lw6sys_assoc_free (lw6_global.map_smobs);
  lw6sys_assoc_free (lw6_global.game_struct_smobs);
  lw6sys_assoc_free (lw6_global.game_state_smobs);
  lw6sys_assoc_free (lw6_global.game_look_smobs);

  LW6_MUTEX_UNLOCK;

  pthread_mutex_destroy (&lw6_global.mutex);
}
