/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "gl-view.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
	      _("view backend function \"%s\" is not defined"));
}

int
mod_gl_view_init (MOD_GL_UTILS_CONTEXT * utils_context,
		  MOD_GL_VIEW_BACKEND * backend)
{
  if (backend->init)
    {
      backend->view_context = backend->init (utils_context);
    }
  else
    {
      warning ("view_init");
    }

  return backend->view_context ? 1 : 0;
}

void
mod_gl_view_quit (MOD_GL_UTILS_CONTEXT * utils_context,
		  MOD_GL_VIEW_BACKEND * backend)
{
  if (backend->quit)
    {
      backend->quit (utils_context, backend->view_context);
    }
  else
    {
      warning ("view_quit");
    }
}

void
mod_gl_view_display_preview (MOD_GL_UTILS_CONTEXT * utils_context,
			     MOD_GL_VIEW_BACKEND * backend, LW6MAP_MAP * map)
{
  if (backend->display_preview)
    {
      backend->display_preview (utils_context, backend->view_context, map);
    }
  else
    {
      warning ("view_display_preview");
    }
}

void
mod_gl_view_display_zones (MOD_GL_UTILS_CONTEXT * utils_context,
			   MOD_GL_VIEW_BACKEND * backend,
			   LW6MAP_MAP * map, LW6KER_MAP_STRUCT * map_struct)
{
  if (backend->display_zones)
    {
      backend->display_zones (utils_context, backend->view_context, map,
			      map_struct);
    }
  else
    {
      warning ("view_display_zones");
    }
}

void
mod_gl_view_display_gradient (MOD_GL_UTILS_CONTEXT * utils_context,
			      MOD_GL_VIEW_BACKEND * backend,
			      LW6MAP_MAP * map,
			      LW6KER_MAP_STATE * map_state, int team_id)
{
  if (backend->display_gradient)
    {
      backend->display_gradient (utils_context, backend->view_context, map,
				 map_state, team_id);
    }
  else
    {
      warning ("view_display_gradient");
    }
}

void
mod_gl_view_display_game (MOD_GL_UTILS_CONTEXT * utils_context,
			  MOD_GL_VIEW_BACKEND * backend,
			  LW6MAP_MAP * map,
			  LW6KER_GAME_STATE * game_state,
			  LW6GFX_GAME_LOOK * game_look)
{
  if (backend->display_game)
    {
      backend->display_game (utils_context, backend->view_context,
			     map, game_state, game_look);
    }
  else
    {
      warning ("view_display_game");
    }
}

void
mod_gl_view_pick_map_coord (MOD_GL_UTILS_CONTEXT * utils_context,
			    MOD_GL_VIEW_BACKEND * backend, int *map_x,
			    int *map_y, LW6MAP_MAP * map,
			    LW6KER_GAME_STATE * game_state, int screen_x,
			    int screen_y)
{
  if (backend->pick_map_coord)
    {
      backend->pick_map_coord (utils_context, backend->view_context,
			       map_x, map_y, map, game_state, screen_x,
			       screen_y);
    }
  else
    {
      warning ("view_pick_map_coord");
    }
}
