/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <GL/glu.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-flat.h"
#include "gl-flat-internal.h"

#define MIN_SIDE 1.0f

void
_mod_gl_view_flat_pick_map_coord (MOD_GL_UTILS_CONTEXT * utils_context,
				  _MOD_GL_VIEW_FLAT_CONTEXT *
				  flat_context,
				  int *map_x,
				  int *map_y,
				  LW6MAP_MAP * map,
				  LW6KER_GAME_STATE * game_state,
				  int screen_x, int screen_y)
{
  float screen_x1, screen_y1, screen_x2, screen_y2;
  float screen_w, screen_h;

  mod_gl_utils_viewport_calc_map_area (utils_context, &screen_x1, &screen_y1,
				       &screen_x2, &screen_y2,
				       map->texture.shape.w,
				       map->texture.shape.h, &(map->param));

  screen_w = screen_x2 - screen_x1;
  screen_h = screen_y2 - screen_y1;

  if (screen_w < MIN_SIDE)
    {
      screen_w = MIN_SIDE;
    }
  if (screen_h < MIN_SIDE)
    {
      screen_h = MIN_SIDE;
    }

  if (screen_x < screen_x1 || screen_x > screen_x2 || screen_y < screen_y1
      || screen_y > screen_y2)
    {
      // out of range
      (*map_x) = -1;
      (*map_y) = -1;
    }
  else
    {
      (*map_x) =
	((float) map->depth.shape.w) * (screen_x - screen_x1) / screen_w;
      (*map_y) =
	((float) map->depth.shape.h) * (screen_y - screen_y1) / screen_h;
    }
}

void
mod_gl_view_flat_pick_map_coord (MOD_GL_UTILS_CONTEXT *
				 utils_context,
				 void *flat_context,
				 int *map_x,
				 int *map_y,
				 LW6MAP_MAP * map,
				 LW6KER_GAME_STATE * game_state,
				 int screen_x, int screen_y)
{
  _mod_gl_view_flat_pick_map_coord (utils_context,
				    (_MOD_GL_VIEW_FLAT_CONTEXT *)
				    flat_context, map_x, map_y, map,
				    game_state, screen_x, screen_y);
}
