/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

SDL_Color
mod_gl_utils_color_sys2sdl (LW6SYS_COLOR_F * color_f)
{
  LW6SYS_COLOR_8 color_8;
  SDL_Color ret;

  color_8 = lw6sys_color_f_to_8 (color_f);
  ret.r = color_8.r;
  ret.g = color_8.g;
  ret.b = color_8.b;
  ret.unused = 0;

  return ret;
}

static Uint32
prepare_shaded_color_for_fighter (Uint32 color, int j)
{
  Uint32 ret = 0xFFFFFFFF;	// alpha must be 0xFF
  unsigned char *p_src;
  unsigned char *p_dst;
  unsigned char c;
  int i;

  p_src = (unsigned char *) &color;
  p_dst = (unsigned char *) &ret;

  /*
   * Slow but we don't care, executed at startup.
   */
  for (i = 0; i < sizeof (Uint32) - 1; ++i)
    {
      c =
	(((unsigned int) (*(p_src + i))) * j) /
	MOD_GL_SHADES_FOR_FIGHTERS_SCALE;
      (*(p_dst + i)) = c;
    }

  return ret;
}

Uint32
get_team_color (LW6MAP_STYLE * map_style, int id)
{
  Uint32 ret;
  LW6SYS_COLOR_F color_f;

  lw6map_style_get_team_color (map_style, &color_f, id);

  ret = lw6sys_color_f_to_i (&color_f);

  return ret;
}

void
mod_gl_utils_update_team_color_map (MOD_GL_UTILS_TEAM_COLOR_MAP *
				    team_color_map, LW6MAP_STYLE * map_style)
{
  int i, j;
  Uint32 test;

  for (i = 0; i < LW6OPT_MAX_NB_TEAMS; ++i)
    {
      test = prepare_shaded_color_for_fighter (get_team_color
					       (map_style, i),
					       MOD_GL_SHADES_FOR_FIGHTERS_SCALE);
      if (test !=
	  team_color_map->team_colors[i][MOD_GL_SHADES_FOR_FIGHTERS_SCALE])
	{
	  for (j = 0; j < MOD_GL_SHADES_FOR_FIGHTERS_SCALE + 1; ++j)
	    {
	      team_color_map->team_colors[i][j] =
		prepare_shaded_color_for_fighter (get_team_color
						  (map_style, i), j);
	    }
	}
    }
}
