/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-cylinder.h"
#include "gl-cylinder-internal.h"

/*
 * Low-level SDL initialisation.
 */
_MOD_GL_MENU_CYLINDER_CONTEXT *
_mod_gl_menu_cylinder_init (MOD_GL_UTILS_CONTEXT * utils_context)
{
  _MOD_GL_MENU_CYLINDER_CONTEXT *cylinder_context = NULL;

  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("init menu/cylinder"));

  cylinder_context =
    (_MOD_GL_MENU_CYLINDER_CONTEXT *)
    LW6SYS_CALLOC (sizeof (_MOD_GL_MENU_CYLINDER_CONTEXT));
  if (!cylinder_context)
    {
      /*
       * No use to continue if this basic malloc fails...
       */
      exit (1);
    }

  if (_mod_gl_menu_cylinder_load_data (utils_context, cylinder_context))
    {
      cylinder_context->menu_states =
	lw6sys_assoc_new ((void (*)(void *)) lw6gfx_menu_state_free);
      if (cylinder_context)
	{
	  //ok
	}
      else
	{
	  LW6SYS_FREE (cylinder_context);
	  cylinder_context = NULL;
	}
    }
  else
    {
      LW6SYS_FREE (cylinder_context);
      cylinder_context = NULL;
    }

  return cylinder_context;
}

void *
mod_gl_menu_cylinder_init (MOD_GL_UTILS_CONTEXT * utils_context)
{
  return (void *) _mod_gl_menu_cylinder_init (utils_context);
}

/*
 * Ends-up all SDL stuff.
 */
void
_mod_gl_menu_cylinder_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			    _MOD_GL_MENU_CYLINDER_CONTEXT * cylinder_context)
{
  if (cylinder_context)
    {
      lw6sys_assoc_free (cylinder_context->menu_states);
      LW6SYS_FREE (cylinder_context);
    }
}

void
mod_gl_menu_cylinder_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			   void *cylinder_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("quit menu/cylinder"));

  _mod_gl_menu_cylinder_quit (utils_context,
			      (_MOD_GL_MENU_CYLINDER_CONTEXT *)
			      cylinder_context);
}
