/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-tactical.h"
#include "gl-tactical-internal.h"

/*
 * Low-level SDL initialisation.
 */
_MOD_GL_HUD_TACTICAL_CONTEXT *
_mod_gl_hud_tactical_init (MOD_GL_UTILS_CONTEXT * utils_context)
{
  _MOD_GL_HUD_TACTICAL_CONTEXT *tactical_context = NULL;

  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("init hud/tactical"));

  tactical_context =
    (_MOD_GL_HUD_TACTICAL_CONTEXT *)
    LW6SYS_MALLOC (sizeof (_MOD_GL_HUD_TACTICAL_CONTEXT));
  if (!tactical_context)
    {
      /*
       * No use to continue if this basic malloc fails...
       */
      exit (1);
    }

  memset (tactical_context, 0, sizeof (_MOD_GL_HUD_TACTICAL_CONTEXT));


  if (!_mod_gl_hud_tactical_load_data (utils_context, tactical_context))
    {
      LW6SYS_FREE (tactical_context);
      tactical_context = NULL;
    }

  return tactical_context;
}

void *
mod_gl_hud_tactical_init (MOD_GL_UTILS_CONTEXT * utils_context)
{
  return (void *) _mod_gl_hud_tactical_init (utils_context);
}

/*
 * Ends-up all SDL stuff.
 */
void
_mod_gl_hud_tactical_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			   _MOD_GL_HUD_TACTICAL_CONTEXT * tactical_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("quit hud/tactical"));

  _mod_gl_hud_tactical_unload_data (utils_context, tactical_context);
  LW6SYS_FREE (tactical_context);
}

void
mod_gl_hud_tactical_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			  void *tactical_context)
{
  _mod_gl_hud_tactical_quit (utils_context,
			     (_MOD_GL_HUD_TACTICAL_CONTEXT *)
			     tactical_context);
}
