/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_HUD_TACTICAL_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_HUD_TACTICAL_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "gl-tactical.h"

typedef struct _MOD_GL_HUD_TACTICAL_IMAGE_DATA_STRUCT
{
  SDL_Surface *frame;
}
_MOD_GL_HUD_TACTICAL_IMAGE_DATA;

typedef struct _MOD_GL_HUD_TACTICAL_TEXTURE_DATA_STRUCT
{
  GLuint frame;
}
_MOD_GL_HUD_TACTICAL_TEXTURE_DATA;

typedef struct _MOD_GL_HUD_TACTICAL_CONST_DATA_STRUCT
{
  float viewport_x;
  float viewport_y;
  float viewport_w;
  float viewport_h;
}
_MOD_GL_HUD_TACTICAL_CONST_DATA;

typedef struct _MOD_GL_HUD_TACTICAL_CONTEXT_STRUCT
{
  _MOD_GL_HUD_TACTICAL_IMAGE_DATA image_data;
  _MOD_GL_HUD_TACTICAL_TEXTURE_DATA texture_data;
  _MOD_GL_HUD_TACTICAL_CONST_DATA const_data;
}
_MOD_GL_HUD_TACTICAL_CONTEXT;

/*
 * In display.c
 */
extern void _mod_gl_hud_tactical_display (MOD_GL_UTILS_CONTEXT *
					  utils_context,
					  _MOD_GL_HUD_TACTICAL_CONTEXT
					  * tactical_context,
					  LW6KER_GAME_STATE * game_state);
extern void _mod_gl_hud_tactical_display_preview (MOD_GL_UTILS_CONTEXT *
						  utils_context,
						  _MOD_GL_HUD_TACTICAL_CONTEXT
						  * tactical_context);

/*
 * In data.c
 */
extern int _mod_gl_hud_tactical_load_data (MOD_GL_UTILS_CONTEXT *
					   utils_context,
					   _MOD_GL_HUD_TACTICAL_CONTEXT
					   * tactical_context);
extern void _mod_gl_hud_tactical_unload_data (MOD_GL_UTILS_CONTEXT *
					      utils_context,
					      _MOD_GL_HUD_TACTICAL_CONTEXT
					      * tactical_context);

/*
 * In setup.c
 */
extern _MOD_GL_HUD_TACTICAL_CONTEXT
  * _mod_gl_hud_tactical_init (MOD_GL_UTILS_CONTEXT * utils_context);
extern void _mod_gl_hud_tactical_quit (MOD_GL_UTILS_CONTEXT *
				       utils_context,
				       _MOD_GL_HUD_TACTICAL_CONTEXT *
				       tactical_context);

#endif
