/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>

#include <string.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-floating.h"
#include "gl-floating-internal.h"

MOD_GL_HUD_BACKEND *
mod_gl_hud_floating_create_backend (MOD_GL_UTILS_CONTEXT * utils_context)
{
  MOD_GL_HUD_BACKEND *backend;

  backend =
    (MOD_GL_HUD_BACKEND *) LW6SYS_MALLOC (sizeof (MOD_GL_HUD_BACKEND));
  if (backend)
    {
      memset (backend, 0, sizeof (MOD_GL_HUD_BACKEND));

      backend->display = mod_gl_hud_floating_display;
      backend->display_preview = mod_gl_hud_floating_display_preview;
      backend->init = mod_gl_hud_floating_init;
      backend->quit = mod_gl_hud_floating_quit;
    }

  return backend;
}
