/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>

#include <GL/glu.h>

#include "config.h"
#include "../../mod-gl.h"
#include "gl-water-internal.h"

static float
float_random_range (float min, float max)
{
  return ((((float) random ()) / ((float) RAND_MAX)) * (max - min)) + min;
}

static void
set_background_texture_options (MOD_GL_UTILS_CONTEXT * utils_context,
				_MOD_GL_BACKGROUND_WATER_CONTEXT *
				water_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}

static void
background_display (MOD_GL_UTILS_CONTEXT * utils_context,
		    _MOD_GL_BACKGROUND_WATER_CONTEXT * water_context)
{
  mod_gl_utils_set_render_mode_2d (utils_context);

  glBindTexture (GL_TEXTURE_2D, water_context->texture_data.background);
  set_background_texture_options (utils_context, water_context);

  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();
  glTranslatef (0.0f,
		water_context->const_data.yspeed *
		mod_gl_utils_get_ticks (utils_context) / 1000.0f, 0.0f);

  glBegin (GL_QUADS);
  glTexCoord2d (0.0f, 0.0f);
  glVertex3f (0.0f, 0.0f, 0.0f);	// top left
  glTexCoord2d (1.0f, 0.0f);
  glVertex3f (utils_context->screen.width, 0.0f, 0.0f);	// top right
  glTexCoord2d (1.0f, 1.0f);
  glVertex3f (utils_context->screen.width, utils_context->screen.height, 0.0f);	// bottom right
  glTexCoord2d (0.0f, 1.0f);
  glVertex3f (0.0f, utils_context->screen.height, 0.0f);	// bottom left
  glEnd ();

  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();
}

static void
background_display_bubble (MOD_GL_UTILS_CONTEXT * utils_context,
			   _MOD_GL_BACKGROUND_WATER_CONTEXT * water_context,
			   _MOD_GL_BACKGROUND_WATER_BUBBLE * bubble)
{
  int dt;
  float y;
  float x_px, y_px, size2_px;

  if (!bubble->active)
    {
      bubble->active = 1;
      bubble->t0 = mod_gl_utils_get_ticks (utils_context);
      bubble->size =
	float_random_range (water_context->const_data.
			    bubble_size_min,
			    water_context->const_data.bubble_size_max);
      bubble->x = float_random_range (0.0f, 1.0f);
    }

  dt = mod_gl_utils_get_ticks (utils_context) - bubble->t0;
  x_px = bubble->x * utils_context->screen.width;
  y =
    1.0f + (bubble->size / 2.0f) -
    (bubble->size * water_context->const_data.bubble_yspeed * dt / 1000.0f);
  y_px = y * utils_context->screen.height;
  size2_px = (utils_context->screen.height * bubble->size) / 2.0f;

  glBindTexture (GL_TEXTURE_2D, water_context->texture_data.bubble);
  set_background_texture_options (utils_context, water_context);

  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();

  glBegin (GL_QUADS);
  glTexCoord2d (0.0f, 0.0f);
  glVertex3f (x_px - size2_px, y_px - size2_px, 0.0f);	// top left
  glTexCoord2d (1.0f, 0.0f);
  glVertex3f (x_px + size2_px, y_px - size2_px, 0.0f);	// top right
  glTexCoord2d (1.0f, 1.0f);
  glVertex3f (x_px + size2_px, y_px + size2_px, 0.0f);	// bottom right
  glTexCoord2d (0.0f, 1.0f);
  glVertex3f (x_px - size2_px, y_px + size2_px, 0.0f);	// bottom left
  glEnd ();

  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();

  if (y < (-bubble->size / 2.0f))
    {
      bubble->active = 0;
    }
}

static void
background_display_bubbles (MOD_GL_UTILS_CONTEXT * utils_context,
			    _MOD_GL_BACKGROUND_WATER_CONTEXT * water_context)
{
  int i;

  mod_gl_utils_set_render_mode_2d_blend (utils_context);

  glBindTexture (GL_TEXTURE_2D, water_context->texture_data.bubble);
  set_background_texture_options (utils_context, water_context);

  if (water_context->const_data.nb_bubbles >
      _MOD_GL_BACKGROUND_WATER_MAX_BUBBLES)
    {
      water_context->const_data.nb_bubbles =
	_MOD_GL_BACKGROUND_WATER_MAX_BUBBLES;
    }

  for (i = 0; i < water_context->const_data.nb_bubbles; ++i)
    {
      background_display_bubble (utils_context, water_context,
				 &(water_context->state.bubbles[i]));
    }
}

void
_mod_gl_background_water_display (MOD_GL_UTILS_CONTEXT * utils_context,
				  _MOD_GL_BACKGROUND_WATER_CONTEXT *
				  water_context)
{
  background_display (utils_context, water_context);
  background_display_bubbles (utils_context, water_context);
}

void
mod_gl_background_water_display (MOD_GL_UTILS_CONTEXT * utils_context,
				 void *water_context)
{
  _mod_gl_background_water_display (utils_context, water_context);
}
