/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_BACKGROUND_H
#define LIQUIDWAR6GFX_MOD_GL_BACKGROUND_H

#include <ltdl.h>

#include "../../../sys/sys.h"
#include "../../../map/map.h"
#include "../mod-gl.h"
#include "../gl-utils/gl-utils.h"

typedef struct MOD_GL_BACKGROUND_BACKEND_STRUCT
{
  void *background_context;
  char *backend_name;

  void *(*init) (MOD_GL_UTILS_CONTEXT * utils_context);
  void (*quit) (MOD_GL_UTILS_CONTEXT * utils_context,
		void *background_context);
  void (*display) (MOD_GL_UTILS_CONTEXT * utils_context,
		   void *background_context);
}
MOD_GL_BACKGROUND_BACKEND;

/*
 * In api.c
 */
extern void mod_gl_background_display (MOD_GL_UTILS_CONTEXT * utils_context,
				       MOD_GL_BACKGROUND_BACKEND * backend);
extern int mod_gl_background_init (MOD_GL_UTILS_CONTEXT * utils_context,
				   MOD_GL_BACKGROUND_BACKEND * backend);
extern void mod_gl_background_quit (MOD_GL_UTILS_CONTEXT * utils_context,
				    MOD_GL_BACKGROUND_BACKEND * backend);

/*
 * In backend.c
 */
extern MOD_GL_BACKGROUND_BACKEND
  * mod_gl_background_create_backend (MOD_GL_UTILS_CONTEXT * utils_context,
				      char *name);
extern void mod_gl_background_destroy_backend (MOD_GL_UTILS_CONTEXT *
					       utils_context,
					       MOD_GL_BACKGROUND_BACKEND *
					       backend);

#endif
