/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "../mod-gl.h"

#include "gl-air/gl-air.h"
#include "gl-earth/gl-earth.h"
#include "gl-fire/gl-fire.h"
#include "gl-water/gl-water.h"

MOD_GL_BACKGROUND_BACKEND *
mod_gl_background_create_backend (MOD_GL_UTILS_CONTEXT * utils_context,
				  char *name)
{
  MOD_GL_BACKGROUND_BACKEND *(*init_func) (MOD_GL_UTILS_CONTEXT *
					   utils_context) = NULL;
  MOD_GL_BACKGROUND_BACKEND *backend = NULL;

  if (strcmp (name, "air") == 0)
    {
      init_func = mod_gl_background_air_create_backend;
    }
  else if (strcmp (name, "earth") == 0)
    {
      init_func = mod_gl_background_earth_create_backend;
    }
  else if (strcmp (name, "fire") == 0)
    {
      init_func = mod_gl_background_fire_create_backend;
    }
  else if (strcmp (name, "water") == 0)
    {
      init_func = mod_gl_background_water_create_backend;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
		  _("background backend \"%s\" does not exists"), name);
    }

  if (init_func)
    {
      backend = init_func (utils_context);
      if (backend)
	{
	  backend->backend_name = lw6sys_str_copy (name);
	}
    }

  return backend;
}

void
mod_gl_background_destroy_backend (MOD_GL_UTILS_CONTEXT * utils_context,
				   MOD_GL_BACKGROUND_BACKEND * backend)
{
  if (backend)
    {
      if (backend->backend_name)
	{
	  LW6SYS_FREE (backend->backend_name);
	}
      LW6SYS_FREE (backend);
    }
}
