/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <GL/glu.h>
#include <SDL/SDL_image.h>

#include "config.h"
#include "../../../gfx.h"
#include "../../../../cfg/cfg.h"
#include "gl-air.h"
#include "gl-air-internal.h"

#define CONST_FILE "gfx/gl/background/air/const.xml"

#define IMAGE_DIR "gfx/gl/background/air/image/"

#define IMAGE_BACKGROUND "sky.png"
#define IMAGE_CLOUD "cloud.png"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  _MOD_GL_BACKGROUND_AIR_CONST_DATA *const_data;

  const_data = (_MOD_GL_BACKGROUND_AIR_CONST_DATA *) callback_data;

  if (!strcmp (element, "color"))
    {
      lw6cfg_read_xml_color (key, value, "menu-fg", &const_data->menu_fg);
      lw6cfg_read_xml_color (key, value, "menu-bg", &const_data->menu_bg);
      lw6cfg_read_xml_color (key, value, "menu-fg-selected",
			     &const_data->menu_fg_selected);
      lw6cfg_read_xml_color (key, value, "menu-bg-selected",
			     &const_data->menu_bg_selected);
    }
}

static int
load_consts (MOD_GL_UTILS_CONTEXT * utils_context,
	     _MOD_GL_BACKGROUND_AIR_CONTEXT * air_context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_find_data_file (CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("reading \"%s\""),
		  const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(air_context->const_data));

      LW6SYS_FREE (const_file);
    }

  utils_context->const_data.menu_fg = air_context->const_data.menu_fg;
  utils_context->const_data.menu_bg = air_context->const_data.menu_bg;
  utils_context->const_data.menu_fg_selected =
    air_context->const_data.menu_fg_selected;
  utils_context->const_data.menu_bg_selected =
    air_context->const_data.menu_bg_selected;

  return ret;
}

static void
unload_consts (MOD_GL_UTILS_CONTEXT * utils_context,
	       _MOD_GL_BACKGROUND_AIR_CONTEXT * air_context)
{
  memset (&air_context->const_data, 0,
	  sizeof (_MOD_GL_BACKGROUND_AIR_CONST_DATA));
}

/*
 * Loads images from disk.
 */
static int
load_images (MOD_GL_UTILS_CONTEXT * utils_context,
	     _MOD_GL_BACKGROUND_AIR_CONTEXT * air_context)
{
  int ret = 0;

  lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("loading images"));

  ret =
    ((air_context->image_data.background =
      mod_gl_utils_load_image (utils_context, IMAGE_DIR,
			       IMAGE_BACKGROUND)) != NULL) &&
    ((air_context->image_data.cloud =
      mod_gl_utils_load_image (utils_context, IMAGE_DIR,
			       IMAGE_CLOUD)) != NULL);

  if (!ret)
    {
      /*
       * If we can't load images, we simply exit the game...
       */
      exit (1);
    }

  return ret;
}

/*
 * Free memory.
 */
static void
unload_images (MOD_GL_UTILS_CONTEXT * utils_context,
	       _MOD_GL_BACKGROUND_AIR_CONTEXT * air_context)
{
  mod_gl_utils_unload_image (utils_context,
			     air_context->image_data.background);
  mod_gl_utils_unload_image (utils_context, air_context->image_data.cloud);

  memset (&air_context->image_data, 0,
	  sizeof (_MOD_GL_BACKGROUND_AIR_IMAGE_DATA));
}

/*
 * Loads textures from disk.
 */
static int
load_textures (MOD_GL_UTILS_CONTEXT * utils_context,
	       _MOD_GL_BACKGROUND_AIR_CONTEXT * air_context)
{
  int ret = 0;

  ret =
    ((air_context->texture_data.background =
      mod_gl_utils_load_texture (utils_context,
				 air_context->image_data.background)) != 0) &&
    ((air_context->texture_data.cloud =
      mod_gl_utils_load_texture (utils_context,
				 air_context->image_data.cloud)) != 0);

  if (!ret)
    {
      /*
       * If we can't load textures, we simply exit the game...
       */
      exit (1);
    }

  return ret;
}

/*
 * Free memory.
 */
static void
unload_textures (MOD_GL_UTILS_CONTEXT * utils_context,
		 _MOD_GL_BACKGROUND_AIR_CONTEXT * air_context)
{
  mod_gl_utils_unload_texture (utils_context,
			       air_context->texture_data.background);
  mod_gl_utils_unload_texture (utils_context,
			       air_context->texture_data.cloud);
}

/*
 * Putting all the load/unload functions together
 */
int
_mod_gl_background_air_load_data (MOD_GL_UTILS_CONTEXT * utils_context,
				  _MOD_GL_BACKGROUND_AIR_CONTEXT *
				  air_context)
{
  return load_consts (utils_context, air_context) &&
    load_images (utils_context, air_context) &&
    load_textures (utils_context, air_context);
}

void
_mod_gl_background_air_unload_data (MOD_GL_UTILS_CONTEXT * utils_context,
				    _MOD_GL_BACKGROUND_AIR_CONTEXT *
				    air_context)
{
  unload_consts (utils_context, air_context);
  unload_images (utils_context, air_context);
  unload_textures (utils_context, air_context);
}
