/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "gfx.h"

/*
 * Creates a menu_state struct.
 */
LW6GFX_MENU_STATE *
lw6gfx_menu_state_new ()
{
  LW6GFX_MENU_STATE *menu_state = NULL;

  menu_state =
    (LW6GFX_MENU_STATE *) LW6SYS_CALLOC (sizeof (LW6GFX_MENU_STATE));

  return menu_state;
}

/*
 * Frees a menu_state struct.
 */
void
lw6gfx_menu_state_free (LW6GFX_MENU_STATE * menu_state)
{
  if (menu_state)
    {
      LW6SYS_FREE (menu_state);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx",
		  _("trying to free NULL menu_state"));
    }
}

/*
 * Calculates a new menu_state, that is, updates parameters such as
 * "which menuitem is displayed first" according to the previous
 * state and the given menu.
 */
void
lw6gfx_menu_state_update (LW6GFX_MENU_STATE * menu_state, LW6GFX_MENU * menu,
			  int max_displayed_items)
{
  if (menu->nb_items > max_displayed_items)
    {
      /*
       * Here there are more items in the menu than the max
       * displayable number. 
       */
      menu_state->nb_items_displayed = max_displayed_items;

      while (menu_state->first_item_displayed > menu->selected_item - 1)
	{
	  menu_state->first_item_displayed--;
	}
      while (menu_state->first_item_displayed +
	     menu_state->nb_items_displayed - 1 < menu->selected_item + 1)
	{
	  menu_state->first_item_displayed++;
	}

      // Checking for absolute limits.
      if (menu_state->first_item_displayed < 0)
	{
	  menu_state->first_item_displayed = 0;
	}
      if (menu_state->first_item_displayed + menu_state->nb_items_displayed >
	  menu->nb_items)
	{
	  menu_state->first_item_displayed =
	    menu->nb_items - menu_state->nb_items_displayed;
	}
    }
  else
    {
      menu_state->first_item_displayed = 0;
      menu_state->nb_items_displayed = menu->nb_items;
    }
}
