/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "gfx.h"

/*
 * Creates a menuitem struct.
 */
LW6GFX_MENUITEM *
lw6gfx_menuitem_new (char *label, LW6GFX_MENUITEM_TYPE type, int enabled,
		     int value, int selected_char)
{
  LW6GFX_MENUITEM *menuitem = NULL;

  menuitem = (LW6GFX_MENUITEM *) LW6SYS_CALLOC (sizeof (LW6GFX_MENUITEM));

  if (menuitem)
    {
      menuitem->label = lw6sys_str_copy (label);
      menuitem->type = type;
      menuitem->enabled = enabled;
      menuitem->value = value;
      menuitem->selected_char = selected_char;
    }

  return menuitem;
}

/*
 * Frees a menuitem struct and all its menuitemitems.
 */
void
lw6gfx_menuitem_free (LW6GFX_MENUITEM * menuitem)
{
  if (menuitem)
    {
      if (menuitem->label)
	{
	  LW6SYS_FREE (menuitem->label);
	}
      LW6SYS_FREE (menuitem);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "gfx",
		  _("trying to free NULL menuitem"));
    }
}
