/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "gfx.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING, "gfx",
	      _("gfx backend function \"%s\" is not defined"), func_name);
}

void
lw6gfx_display_background (LW6GFX_BACKEND * backend, char *skin)
{
  if (backend->display_background)
    {
      backend->display_background (backend->gfx_context, skin);
    }
  else
    {
      warning ("display_background");
    }
}

void
lw6gfx_display_hud (LW6GFX_BACKEND * backend, LW6KER_GAME_STATE * game_state,
		    LW6GFX_HUD_STEP step, char *skin)
{
  if (backend->display_hud)
    {
      backend->display_hud (backend->gfx_context, game_state, step, skin);
    }
  else
    {
      warning ("display_hud");
    }
}

void
lw6gfx_display_hud_preview (LW6GFX_BACKEND * backend, LW6GFX_HUD_STEP step,
			    char *skin)
{
  if (backend->display_hud_preview)
    {
      backend->display_hud_preview (backend->gfx_context, step, skin);
    }
  else
    {
      warning ("display_hud_preview");
    }
}

int
lw6gfx_poll_keypress (LW6GFX_BACKEND * backend, LW6GFX_KEYPRESS * keypress)
{
  int ret = 0;

  if (backend->poll_keypress)
    {
      ret = backend->poll_keypress (backend->gfx_context, keypress);
    }
  else
    {
      warning ("poll_keypress");
    }

  return ret;
}

int
lw6gfx_is_key_esc (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_esc)
    {
      ret = backend->is_key_esc (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_esc");
    }

  return ret;
}

int
lw6gfx_is_key_up (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_up)
    {
      ret = backend->is_key_up (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_up");
    }

  return ret;
}

int
lw6gfx_is_key_down (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_down)
    {
      ret = backend->is_key_down (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_down");
    }

  return ret;
}

int
lw6gfx_is_key_left (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_left)
    {
      ret = backend->is_key_left (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_left");
    }

  return ret;
}

int
lw6gfx_is_key_right (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_right)
    {
      ret = backend->is_key_right (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_right");
    }

  return ret;
}

int
lw6gfx_is_key_enter (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_enter)
    {
      ret = backend->is_key_enter (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_enter");
    }

  return ret;
}

int
lw6gfx_is_key_del (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_del)
    {
      ret = backend->is_key_del (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_del");
    }

  return ret;
}

int
lw6gfx_is_key_backspace (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_backspace)
    {
      ret = backend->is_key_backspace (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_backspace");
    }

  return ret;
}

int
lw6gfx_is_key_help (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_help)
    {
      ret = backend->is_key_help (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_help");
    }

  return ret;
}

int
lw6gfx_is_key_quit (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_quit)
    {
      ret = backend->is_key_quit (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_quit");
    }

  return ret;
}

int
lw6gfx_poll_quit (LW6GFX_BACKEND * backend)
{
  int ret = 0;

  if (backend->poll_quit)
    {
      ret = backend->poll_quit (backend->gfx_context);
    }
  else
    {
      warning ("poll_quit");
    }

  return ret;
}

void
lw6gfx_send_quit (LW6GFX_BACKEND * backend)
{
  if (backend->send_quit)
    {
      backend->send_quit (backend->gfx_context);
    }
  else
    {
      warning ("send_quit");
    }
}

int
lw6gfx_get_key_state (LW6GFX_BACKEND * backend, int keysym)
{
  int ret = 0;

  if (backend->get_key_state)
    {
      ret = backend->get_key_state (backend->gfx_context, keysym);
    }
  else
    {
      warning ("get_key_state");
    }

  return ret;
}

int
lw6gfx_poll_mouse_move (LW6GFX_BACKEND * backend, int *x, int *y)
{
  int ret = 0;

  if (backend->poll_mouse_button)
    {
      ret = backend->poll_mouse_move (backend->gfx_context, x, y);
    }
  else
    {
      warning ("poll_mouse_move");
    }

  return ret;
}

int
lw6gfx_poll_mouse_button (LW6GFX_BACKEND * backend, int button)
{
  int ret = 0;

  if (backend->poll_mouse_button)
    {
      ret = backend->poll_mouse_button (backend->gfx_context, button);
    }
  else
    {
      warning ("poll_mouse_button");
    }

  return ret;
}

void
lw6gfx_get_mouse_state (LW6GFX_BACKEND * backend, int *x, int *y,
			int *button_left, int *button_right)
{
  if (backend->get_mouse_state)
    {
      backend->get_mouse_state (backend->gfx_context, x, y, button_left,
				button_right);
    }
  else
    {
      warning ("get_mouse_state");
    }
}

void
lw6gfx_display_sysinfo (LW6GFX_BACKEND * backend, int fps, int rps,
			int bytes_in, int bytes_out)
{
  if (backend->display_sysinfo)
    {
      backend->display_sysinfo (backend->gfx_context, fps, rps, bytes_in,
				bytes_out);
    }
  else
    {
      warning ("display_sysinfo");
    }
}
void
lw6gfx_display_log (LW6GFX_BACKEND * backend, char **log)
{
  if (backend->display_log)
    {
      backend->display_log (backend->gfx_context, log);
    }
  else
    {
      warning ("display_log");
    }
}
void
lw6gfx_display_time (LW6GFX_BACKEND * backend, long long seconds)
{
  if (backend->display_time)
    {
      backend->display_time (backend->gfx_context, seconds);
    }
  else
    {
      warning ("display_time");
    }
}
void
lw6gfx_display_version (LW6GFX_BACKEND * backend)
{
  if (backend->display_version)
    {
      backend->display_version (backend->gfx_context);
    }
  else
    {
      warning ("display_version");
    }
}

void
lw6gfx_display_map_preview (LW6GFX_BACKEND * backend, LW6MAP_MAP * map,
			    char *skin)
{
  if (backend->display_map_preview)
    {
      backend->display_map_preview (backend->gfx_context, map, skin);
    }
  else
    {
      warning ("display_map_preview");
    }
}

void
lw6gfx_display_map_zones (LW6GFX_BACKEND * backend,
			  LW6MAP_MAP * map,
			  LW6KER_MAP_STRUCT * map_struct, char *skin)
{
  if (backend->display_map_zones)
    {
      backend->display_map_zones (backend->gfx_context, map, map_struct,
				  skin);
    }
  else
    {
      warning ("display_map_zones");
    }
}

void
lw6gfx_display_map_gradient (LW6GFX_BACKEND * backend,
			     LW6MAP_MAP * map,
			     LW6KER_MAP_STATE * map_state, int team_id,
			     char *skin)
{
  if (backend->display_map_gradient)
    {
      backend->display_map_gradient (backend->gfx_context, map, map_state,
				     team_id, skin);
    }
  else
    {
      warning ("display_map_gradient");
    }
}

void
lw6gfx_display_game (LW6GFX_BACKEND * backend, LW6MAP_MAP * map,
		     LW6KER_GAME_STATE * game_state,
		     LW6GFX_GAME_LOOK * game_look, char *skin)
{
  if (backend->display_game)
    {
      backend->display_game (backend->gfx_context, map, game_state, game_look,
			     skin);
    }
  else
    {
      warning ("display_game");
    }
}

void
lw6gfx_pick_map_coord (LW6GFX_BACKEND * backend, int *map_x, int *map_y,
		       LW6MAP_MAP * map, LW6KER_GAME_STATE * game_state,
		       int screen_x, int screen_y, char *skin)
{
  if (backend->pick_map_coord)
    {
      backend->pick_map_coord (backend->gfx_context, map_x, map_y, map,
			       game_state, screen_x, screen_y, skin);
    }
  else
    {
      warning ("pick_map_coord");
    }
}

void
lw6gfx_display_menu (LW6GFX_BACKEND * backend, LW6GFX_MENU * menu, char *skin)
{
  if (backend->display_menu)
    {
      backend->display_menu (backend->gfx_context, menu, skin);
    }
  else
    {
      warning ("display_menu");
    }
}

int
lw6gfx_pick_menuitem (LW6GFX_BACKEND * backend, LW6GFX_MENU * menu,
		      int screen_x, int screen_y, char *skin)
{
  int ret = 0;

  if (backend->pick_menuitem)
    {
      ret =
	backend->pick_menuitem (backend->gfx_context, menu, screen_x,
				screen_y, skin);
    }
  else
    {
      warning ("pick_menuitem");
    }

  return ret;
}

void
lw6gfx_prepare_buffer (LW6GFX_BACKEND * backend)
{
  if (backend->prepare_buffer)
    {
      backend->prepare_buffer (backend->gfx_context);
    }
  else
    {
      warning ("prepare_buffer");
    }
}
void
lw6gfx_swap_buffers (LW6GFX_BACKEND * backend)
{
  if (backend->swap_buffers)
    {
      backend->swap_buffers (backend->gfx_context);
    }
  else
    {
      warning ("swap_buffers");
    }
}
int
lw6gfx_init (LW6GFX_BACKEND * backend, int width,
	     int height, int fullscreen,
	     void (*resize_callback) (int width, int height, int fullscreen),
	     int ticks)
{
  if (backend->init)
    {
      backend->gfx_context =
	backend->init (width, height, fullscreen, resize_callback, ticks);
    }
  else
    {
      warning ("init");
    }

  return backend->gfx_context ? 1 : 0;
}

int
lw6gfx_set_video_mode (LW6GFX_BACKEND * backend, int width, int height,
		       int fullscreen, void (*resize_callback) (int width,
								int height,
								int
								fullscreen))
{
  int ret = 0;

  if (backend->set_video_mode)
    {
      ret =
	backend->set_video_mode (backend->gfx_context, width, height,
				 fullscreen, resize_callback);
    }
  else
    {
      warning ("set_video_mode");
    }

  return ret;
}

void
lw6gfx_quit (LW6GFX_BACKEND * backend)
{
  if (backend->quit)
    {
      backend->quit (backend->gfx_context);
      backend->gfx_context = NULL;
    }
  else
    {
      warning ("quit");
    }
}
void
lw6gfx_delay (LW6GFX_BACKEND * backend, int ms)
{
  if (backend->delay)
    {
      backend->delay (backend->gfx_context, ms);
    }
  else
    {
      warning ("delay");
    }
}
int
lw6gfx_get_ticks (LW6GFX_BACKEND * backend)
{
  int ret = 0;

  if (backend->get_ticks)
    {
      ret = backend->get_ticks (backend->gfx_context);
    }
  else
    {
      warning ("get_ticks");
    }

  return ret;
}
