/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "dyn.h"

static lt_dlhandle
verbose_dlopen (char *file)
{
  lt_dlhandle ret = NULL;
  int nb_errs = 0;

  if ((nb_errs = lt_dlinit ()) > 0)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "dyn",
		  _("couldn't initialize libltdl, %d errors"), nb_errs);
    }
  else
    {
      ret = lt_dlopen (file);
    }

  if (ret)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "dyn", _("dlopen \"%s\""), file);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "dyn",
		  _("couldn't open shared library \"%s\""), file);
    }

  return ret;
}

LW6DYN_DL_HANDLE *
lw6dyn_dlopen_backend (char *top_level_lib, char *backend_name)
{
  LW6DYN_DL_HANDLE *ret = NULL;

  ret = LW6SYS_CALLOC (sizeof (LW6DYN_DL_HANDLE));
  if (ret)
    {
      ret->library_path =
	lw6dyn_path_find_backend (top_level_lib, backend_name);
      if (ret->library_path)
	{
	  ret->handle = verbose_dlopen (ret->library_path);
	  if (!ret->handle)
	    {
	      LW6SYS_FREE (ret->library_path);
	      LW6SYS_FREE (ret);
	      ret = NULL;
	    }
	}
      else
	{
	  LW6SYS_FREE (ret);
	  ret = NULL;
	}
    }

  return ret;
}

int
lw6dyn_dlclose_backend (LW6DYN_DL_HANDLE * handle)
{
  int nb_errs;
  int ret = 0;

  if (handle)
    {
      /*
       * Just for this log line, it's interesting to wrap
       * the libtool lt_dlclose in our own function: when freeing
       * a loaded shared library, we know *what* we're freeing,
       * which can be pretty usefull when debugging.
       */
      lw6sys_log (LW6SYS_LOG_INFO, "dyn", _("dlclose \"%s\""),
		  handle->library_path);
      if (handle->handle)
	{
	  if (lt_dlclose (handle->handle))
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING, "dyn",
			  _("couldn't unload shared library"));
	      ret = 1;
	    }
	}

      if ((nb_errs = lt_dlexit ()) > 0)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "dyn",
		      _("couldn't exit libltdl, %d errors"), nb_errs);
	  ret = 0;
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "dyn",
		  _("trying to free NULL dl_handle"));
    }

  LW6SYS_FREE (handle->library_path);
  LW6SYS_FREE (handle);

  return ret;
}

void *
lw6dyn_dlsym (LW6DYN_DL_HANDLE * handle, char *func_name)
{
  return lt_dlsym (handle->handle, func_name);
}
