/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6CFG_H
#define LIQUIDWAR6CFG_H

#include "../lw6-common.h"

#include "../sys/sys.h"

/*
 * In commandline.c
 */
extern int lw6cfg_parse_command_line (void *context, int argc, char *argv[]);

/*
 * In dir.c
 */
extern char *lw6cfg_get_default_system_config_file (void *context);
extern char *lw6cfg_get_default_user_config_file (void *context);

/*
 * In load.c
 */
extern int lw6cfg_load (void *context, char *filename);

/*
 * In option.c
 */
extern int lw6cfg_option_exists (void *context, char *key);
extern char *lw6cfg_get_option (void *context, char *key);
extern void lw6cfg_set_option (void *context, char *key, char *value);
extern int lw6cfg_get_option_int (void *context, char *key);
extern void lw6cfg_set_option_int (void *context, char *key, int value);
extern int lw6cfg_get_option_bool (void *context, char *key);
extern void lw6cfg_set_option_bool (void *context, char *key, int value);

/*
 * In save.c
 */
extern int lw6cfg_save (void *context, char *filename);

/*
 * In setup.c
 */
extern void *lw6cfg_init ();
extern void lw6cfg_quit (void *context);

/*
 * Functions in xml.c
 */
extern void lw6cfg_read_xml_int (char *xml_key, char *xml_value,
				 char *target_key, int *value);
extern void lw6cfg_read_xml_bool (char *xml_key, char *xml_value,
				  char *target_key, int *value);
extern void lw6cfg_read_xml_float (char *xml_key, char *xml_value,
				   char *target_key, float *value);
extern void lw6cfg_read_xml_string (char *xml_key, char *xml_value,
				    char *target_key, char **value);
extern void lw6cfg_read_xml_color (char *xml_key, char *xml_value,
				   char *target_key, LW6SYS_COLOR_F * value);
extern int lw6cfg_read_key_value_xml_file (char *filename,
					   void (*callback_func) (void
								  *callback_data,
								  char
								  *element,
								  char *key,
								  char
								  *value),
					   void *callback_data);

#endif
