/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <locale.h>

#include "config.h"
#include "cfg.h"

#define TEST_CFG "/tmp/liquidwar6-config.xml"

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"cfg-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"cfg-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"cfg-test",_("tests in \"%s\" failed"),__FUNCTION__); }

/*
 * Testing directory functions
 */
static int
test_dir ()
{
  int ret = 1;
  void *context;
  FUNCTION_BEGIN;

  context = lw6cfg_init ();
  if (context)
    {
      {
	lw6sys_log (LW6SYS_LOG_DEBUG, "cfg-test",
		    _("default system config file is \"%s\""),
		    lw6cfg_get_default_system_config_file (context));
      }

      {
	lw6sys_log (LW6SYS_LOG_DEBUG, "cfg-test",
		    _("default user config file is \"%s\""),
		    lw6cfg_get_default_user_config_file (context));
      }
      lw6cfg_quit (context);
    }
  else
    {
      ret = 0;
    }

  FUNCTION_END;
  return ret;
}

/*
 * Testing loading/saving
 */
static int
test_load_save ()
{
  int ret = 1;
  void *context;
  FUNCTION_BEGIN;

  context = lw6cfg_init ();
  if (context)
    {
      {
	/*
	 * Note: we don't consider the test as invalid if the
	 * file does not exist, after all, it's a normal behavior
	 * of the game to be launched without any config file.
	 */
	lw6cfg_load (context, TEST_CFG);
	lw6cfg_save (context, TEST_CFG);
      }
      lw6cfg_quit (context);
    }
  else
    {
      ret = 0;
    }

  FUNCTION_END;
  return ret;
}

int
main (int argc, char *argv[])
{
  int ret = 1;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  ret = test_dir () && test_load_save ();

  ret = ret && lw6sys_check_malloc_free_count ();

  return (!ret);
}
