/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6CFG_INTERNAL_H
#define LIQUIDWAR6CFG_INTERNAL_H

#include "../sys/sys.h"

typedef struct _LW6CFG_OPTION_STRUCT
{
  int from_command_line;
  char *key;
  char *value;
}
_LW6CFG_OPTION;

typedef struct _LW6CFG_CONTEXT_STRUCT
{
  char *default_system_config_file;
  char *default_user_config_file;
  LW6SYS_ASSOC *options;
}
_LW6CFG_CONTEXT;

typedef struct _LW6CFG_XML_CALLBACK_STRUCT
{
  void (*func) (void *data, char *element, char *key, char *value);
  void *data;
}
_LW6CFG_XML_CALLBACK;

/*
 * In dir.c
 */

extern void _lw6cfg_set_default_system_config_file (_LW6CFG_CONTEXT *
						    context);
extern char *_lw6xfg_get_default_system_config_file (_LW6CFG_CONTEXT *
						     context);
extern void _lw6cfg_set_default_user_config_file (_LW6CFG_CONTEXT * context);
extern char *_lw6cfg_get_default_user_config_file (_LW6CFG_CONTEXT * context);

/*
 * In load.c
 */
extern int _lw6cfg_load (_LW6CFG_CONTEXT * context, char *filename);

/*
 * In option.c
 */
extern int _lw6cfg_option_exists (_LW6CFG_CONTEXT * context, char *key);
extern char *_lw6cfg_get_option (_LW6CFG_CONTEXT * context, char *key);
extern void _lw6cfg_set_option (_LW6CFG_CONTEXT * context, char *key,
				char *value);
extern int _lw6cfg_get_option_int (_LW6CFG_CONTEXT * context, char *key);
extern void _lw6cfg_set_option_int (_LW6CFG_CONTEXT * context, char *key,
				    int value);
extern int _lw6cfg_get_option_bool (_LW6CFG_CONTEXT * context, char *key);
extern void _lw6cfg_set_option_bool (_LW6CFG_CONTEXT * context, char *key,
				     int value);

/*
 * In save.c
 */
extern int _lw6cfg_save (_LW6CFG_CONTEXT * context, char *filename);

/*
 * In setup.c
 */
extern _LW6CFG_CONTEXT *_lw6cfg_init ();
extern void _lw6cfg_quit (_LW6CFG_CONTEXT * context);

#endif
