/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "cfg.h"
#include "cfg-internal.h"

#define CFG_FILE "config.xml"
#define CFG_DIR_1 LW6_CONF_DIR
#define CFG_DIR_2 "/etc/" PACKAGE_TARNAME "/"
#define CFG_DIR_3 LW6_DATA_DIR "cfg/"
#define CFG_DIR_4 LW6_DATA_DIR
#define CFG_DIR_DEFAULT LW6_CONF_DIR

void
_lw6cfg_set_default_system_config_file (_LW6CFG_CONTEXT * context)
{
  char *dir = NULL;

  if (lw6sys_file_exists (CFG_DIR_1 CFG_FILE))
    {
      dir = CFG_DIR_1;
    }
  else if (lw6sys_file_exists (CFG_DIR_2 CFG_FILE))
    {
      dir = CFG_DIR_2;
    }
  else if (lw6sys_file_exists (CFG_DIR_3 CFG_FILE))
    {
      dir = CFG_DIR_3;
    }
  else if (lw6sys_file_exists (CFG_DIR_4 CFG_FILE))
    {
      dir = CFG_DIR_4;
    }
  if (!dir)
    {
      dir = CFG_DIR_DEFAULT;
    }

  context->default_system_config_file = lw6sys_str_concat (dir, CFG_FILE);
}

char *
_lw6cfg_get_default_system_config_file (_LW6CFG_CONTEXT * context)
{
  return context->default_system_config_file;
}

char *
lw6cfg_get_default_system_config_file (void *context)
{
  return _lw6cfg_get_default_system_config_file ((_LW6CFG_CONTEXT *) context);
}

void
_lw6cfg_set_default_user_config_file (_LW6CFG_CONTEXT * context)
{
  char *dir = NULL;

  dir = getenv ("HOME");
  if (!dir)
    {
      dir = ".";
    }

  context->default_user_config_file =
    lw6sys_str_concat (dir, "/." PACKAGE_TARNAME "/" CFG_FILE);
}

char *
_lw6cfg_get_default_user_config_file (_LW6CFG_CONTEXT * context)
{
  return context->default_user_config_file;
}

char *
lw6cfg_get_default_user_config_file (void *context)
{
  return _lw6cfg_get_default_user_config_file ((_LW6CFG_CONTEXT *) context);
}
