/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "cfg.h"
#include "cfg-internal.h"

static int
parse_option (_LW6CFG_CONTEXT * context, char *option)
{
  int ret = 0;

  if (strlen (option) >= 3)
    {
      char *equal = NULL;
      char *key = NULL;
      char *value = NULL;

      if (strncmp (option, "--", 2) == 0)
	{
	  key = lw6sys_str_copy (option + 2);
	}
      else if (strncmp (option, "-", 1) == 0)
	{
	  key = lw6sys_str_copy (option + 1);
	}

      if (key)
	{
	  equal = strchr (key, '=');

	  if (equal)
	    {
	      (*equal) = '\0';
	      value = equal + 1;
	    }
	  else
	    {
	      /*
	       * An option given without any argument is true by
	       * default that is "--option" and "--option=true"
	       * have the same meaning.
	       */
	      value = "true";
	    }

	  lw6sys_assoc_set (&(context->options), key,
			    lw6sys_str_copy (value));

	  LW6SYS_FREE (key);

	  ret = 1;
	}
    }

  return ret;
}

static int
_lw6cfg_parse_command_line (_LW6CFG_CONTEXT * context, int argc, char *argv[])
{
  int i;
  int ret = 1;

  for (i = 1; i < argc; ++i)
    {
      ret = ret && parse_option (context, argv[i]);
    }

  return ret;
}

int
lw6cfg_parse_command_line (void *context, int argc, char *argv[])
{
  return _lw6cfg_parse_command_line ((_LW6CFG_CONTEXT *) context, argc, argv);
}
