/*
  Liquid War is a multiplayer wargame.
  Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War homepage : http://www.ufoot.org/liquidwar
  Contact author      : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "../liquidwar6common.h"
#include "../liquidwar6sys.h"

void *lw6sys_malloc(int size, char *file, int line, int *counter) {
  void *ptr;

  ptr=malloc(size);

  if (ptr!=NULL) {
    if (counter) {
      (*counter)++;
    }
  } else {
    lw6sys_log_warning("sys", _("malloc %d bytes failed in %s:%d"), size, file,  size);
  }
  
  return ptr;
}

void lw6sys_free(void *ptr, char *file, int line, int * counter) {
  if (ptr!=NULL) {
    free(ptr);
    if (counter) {
      (*counter)++;
    }
  } else {
    lw6sys_log_warning("sys", _("trying to free null pointer in %s:%d"), file, line);
  }
}

int lw6sys_check_malloc_free_count(int *malloc_counter, int *free_counter) {
  if (malloc_counter!=NULL && free_counter!=NULL) {
    if (*malloc_counter!=*free_counter) {
      lw6sys_log_warning("sys",_("possible memory leak, %d calls to malloc and %d calls to free"), *malloc_counter, *free_counter);
    }
  }
}
