/*
  Liquid War is a multiplayer wargame.
  Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War homepage : http://www.ufoot.org/liquidwar
  Contact author      : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <iconv.h>
#include <locale.h>

#include "../liquidwar6common.h"
#include "../liquidwar6sys.h"

/*
 * Used to force strings into UTF8 mode, this is basically
 * to match the TTF font settings used when displaying stuff
 * on OpenGL. String must be freed.
 */
char *lw6sys_locale_to_utf8(char *string) {
  char *locale;
  iconv_t cd;
  char *utf8=NULL;

  locale=bind_textdomain_codeset(PACKAGE,NULL);
  if (!locale) {
    locale="ISO-8859-1";
  }
  if (locale) {    
    cd = iconv_open("UTF-8", locale);

    if (cd != (iconv_t)-1) {
      int ilen;
      int max_olen;
      char *iptr;
      size_t ileft;
      char *optr;
      size_t oleft;

      ilen=strlen(string);
      max_olen=strlen(string)*2;
      
      utf8=LW6SYS_MALLOC(max_olen+1);
      if (utf8) {
	memset(utf8,0,max_olen+1);

	iptr=string;
	ileft=ilen;
	optr=utf8;
	oleft=max_olen;

	if (iconv(cd,&iptr,&ileft,&optr,&oleft) == (size_t) -1) {
	  lw6sys_log_warning("sys","iconv error \"%s\"",string);
	}
      }
      iconv_close(cd);
    } else {
      lw6sys_log_warning("sys","unable to open iconv");      
    }
  }
  
  if (utf8==NULL) {
    utf8=LW6SYS_MALLOC(strlen(string)+1);
    if (utf8!=NULL) {
      strcpy(utf8,string);
    }
  }

  if (utf8==NULL) {
    lw6sys_log_warning("sys","unable to translate string to utf8");
  }

  return utf8;
}



