/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "liquidwar6common.h"
#include "liquidwar6.h"
#include "liquidwar6sys.h"

#define SCRIPT_1 "liquidwar6.scm"
#define SCRIPT_2 "script/liquidwar6.scm"
#define SCRIPT_3 "src/script/liquidwar6.scm"
#define SCRIPT_4 LW6_SCRIPT_FILE

/*
 * Finds the right scheme script to run.
 */
char *lw6_find_script() {
  int ret=1;
  char *script=NULL;

  if (lw6sys_file_exists(SCRIPT_1)) {
    script=SCRIPT_1;
  } else if (lw6sys_file_exists(SCRIPT_2)) {
    script=SCRIPT_2;
  } else if (lw6sys_file_exists(SCRIPT_3)) {
    script=SCRIPT_3;
  } else if (lw6sys_file_exists(SCRIPT_4)) {
    script=SCRIPT_4;
  }
  if (!script) {
    script=LW6_SCRIPT_FILE;
  }

  return script;
}

