/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <SDL/SDL.h>
#include "../liquidwar6common.h"
#include "../liquidwar6gfx.h"
#include "internal.h"

/*
 * Basic wrapper to handle errors and use our defaults settings.
 */
SDL_Surface *_lw6gfx_create_surface(int w, int h) {
  SDL_Surface *image;

  image = SDL_CreateRGBSurface(
			       SDL_SWSURFACE,
			       w, h,
			       32,
#if SDL_BYTEORDER == SDL_LIL_ENDIAN /* OpenGL RGBA masks */
			       0x000000FF,
			       0x0000FF00,
			       0x00FF0000,
			       0xFF000000
#else
			       0xFF000000,
			       0x00FF0000,
			       0x0000FF00,
			       0x000000FF
#endif
	
			       );
  /*
  if (image) {
    memset(image->pixels,0,image->pitch*image->h);
    //memset(image->pixels,0,image->format->BytesPerPixel*image->w*image->h);
  }
  */

  if (image==NULL) {
    lw6sys_log_warning("gfx",_("unable to create image"));
  }

  return image;
}

/*
 * Basic wrapper to handle errors and use our defaults settings.
 */
void _lw6gfx_delete_surface(SDL_Surface *surface) {
  if (surface!=NULL) {
    SDL_FreeSurface(surface);
  } else {
    lw6sys_log_warning("gfx",_("trying to free NULL surface"));
  }
}

void _lw6gfx_clear_surface(SDL_Surface *surface, SDL_Color color) {
  SDL_FillRect(surface,NULL,SDL_MapRGB(surface->format,color.r,color.g,color.b));
}
