/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>

#include <GL/glu.h>
#include "../liquidwar6common.h"
#include "../liquidwar6gfx.h"
#include "internal.h"

static float float_random_range(float min, float max) {
  return ((((float) random())/((float) RAND_MAX))*(max-min))+min;
}

static void set_background_texture_options(_LW6GFX_CONTEXT *context) {
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
}

static void display_background(_LW6GFX_CONTEXT *context) {
  glBindTexture(GL_TEXTURE_2D, context->texture_data.background);
  set_background_texture_options(context);

  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0f,context->const_data.background_yspeed*_lw6gfx_get_ticks(context)/1000.0f,0.0f);

  glBegin(GL_QUADS);
  glTexCoord2d(0.0f,0.0f);
  glVertex3f(0.0f,0.0f,0.0f);			                // top left
  glTexCoord2d(1.0f,0.0f);
  glVertex3f(context->screen.width,0.0f,0.0f);			// top right
  glTexCoord2d(1.0f,1.0f);
  glVertex3f(context->screen.width,context->screen.height,0.0f);// bottom right
  glTexCoord2d(0.0f,1.0f);
  glVertex3f(0.0f,context->screen.height,0.0f);			// bottom left
  glEnd();

  glMatrixMode(GL_TEXTURE);
  glPopMatrix();
}

static void display_background_bubble(_LW6GFX_CONTEXT *context, _LW6GFX_BACKGROUND_BUBBLE *bubble) {
  int dt;
  float y;
  float x_px,y_px,size2_px;

  if (!bubble->active) {
    bubble->active=1;
    bubble->t0=lw6gfx_get_ticks(context);
    bubble->size=float_random_range(context->const_data.background_bubble_size_min,context->const_data.background_bubble_size_max);
    bubble->x=float_random_range(0.0f,1.0f);
  }
  
  dt=lw6gfx_get_ticks(context)-bubble->t0;
  x_px=bubble->x*context->screen.width;
  y=1.0f+(bubble->size/2.0f)-(bubble->size*context->const_data.background_bubble_yspeed*dt/1000.0f);
  y_px=y*context->screen.height;
  size2_px=(context->screen.height*bubble->size)/2.0f;

  glBindTexture(GL_TEXTURE_2D, context->texture_data.background_bubble);
  set_background_texture_options(context);

  glMatrixMode(GL_TEXTURE);
  glPushMatrix();
  glLoadIdentity();

  glBegin(GL_QUADS);
  glTexCoord2d(0.0f,0.0f);
  glVertex3f(x_px-size2_px,y_px-size2_px,0.0f);	// top left
  glTexCoord2d(1.0f,0.0f);
  glVertex3f(x_px+size2_px,y_px-size2_px,0.0f);	// top right
  glTexCoord2d(1.0f,1.0f);
  glVertex3f(x_px+size2_px,y_px+size2_px,0.0f); // bottom right
  glTexCoord2d(0.0f,1.0f);
  glVertex3f(x_px-size2_px,y_px+size2_px,0.0f);	// bottom left
  glEnd();

  glMatrixMode(GL_TEXTURE);
  glPopMatrix();

  if (y<(-bubble->size/2.0f)) {
    bubble->active=0;
  }
}

static void display_background_bubbles(_LW6GFX_CONTEXT *context) {
  int i,n;

  glBindTexture(GL_TEXTURE_2D, context->texture_data.background_bubble);
  set_background_texture_options(context);

  if (context->const_data.background_nb_bubbles>_LW6GFX_BACKGROUND_MAX_BUBBLES) {
    context->const_data.background_nb_bubbles=_LW6GFX_BACKGROUND_MAX_BUBBLES;
  }

  for (i=0;i<context->const_data.background_nb_bubbles;++i) {
    display_background_bubble(context,&(context->background_state.bubbles[i]));
  }
}

/*
 * Displays the background image.
 */
void _lw6gfx_display_background(_LW6GFX_CONTEXT *context) {
  _lw6gfx_set_render_mode_2d(context);
  
  glColor3f(1.0, 1.0, 1.0);
  glEnable(GL_TEXTURE_2D); // for texture

  display_background(context);

  _lw6gfx_set_render_mode_2d_blend(context);

  display_background_bubbles(context);
}

void lw6gfx_display_background(void *context) {
  _lw6gfx_display_background((_LW6GFX_CONTEXT *) context);
}


