/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../liquidwar6common.h"
#include "../liquidwar6sys.h"

#define PATHSIZE 1024

/*
 * Tests if a file exists and is readable.
 */
int lw6sys_file_exists(char *filename) {
  int ret=0;
  FILE *f;

  f=fopen(filename,"r");
  if (f) {
    ret=1;
    fclose(f);
  }

  return ret;
}

/*
 * Returns the path to a config file. String must be freed.
 */
char *lw6sys_get_conf_file(char *conf_dir, char *filename) {
  char *ret;

  ret=(char *) LW6SYS_MALLOC(PATHSIZE);
  if (ret!=NULL) {
    memset(ret,0,PATHSIZE);
    snprintf(ret,PATHSIZE-1,"%s%s",conf_dir,filename);
    if (!lw6sys_file_exists(ret)) {
      char *home;

      home=getenv("HOME");
      if (home!=NULL) {
	memset(ret,0,PATHSIZE);      
	snprintf(ret,PATHSIZE-1,"%s/%s/%s",home,PACKAGE,filename);      
      }
    }
  }

  return ret;
}
