/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <stdio.h>
#include <libguile.h>
#include <locale.h>

#include "liquidwar6common.h"
#include "liquidwar6.h"
#include "liquidwar6gfx.h"

/*
 * Start of program.
 * Liquid War 6 is basically only a scheme interpreter (using libguile)
 * which runs a scheme program, this program being itself fed by
 * C callbacks which provide access to graphical or high-level game
 * logic functions.
 */
int main(int argc, char *argv[]) {
  char *script=NULL;

  setlocale(LC_ALL, "");
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE); 

  SCM func_symbol;
  SCM func;
	
  scm_init_guile();

  SCM_DEVAL_P = 1;
  SCM_BACKTRACE_P = 1;
  SCM_RECORD_POSITIONS_P = 1;
  SCM_RESET_DEBUG_MODE;



  lw6sys_log_info("", _("registering C functions for Guile"));
  lw6_register_scm();
	
  script=lw6_find_script();
  lw6sys_log_info("", _("loading \"%s\""), script);
  scm_c_primitive_load (script);
  
  //  func_symbol = scm_c_lookup("lw6-main");
  //  func = scm_variable_ref(func_symbol);
  //  scm_call_0 (func);

  LW6SYS_CHECK_MALLOC_FREE_COUNT;

  lw6sys_log_info("", _("thanks for playing Liquid War 6 http://www.ufoot.org/liquidwar"));

  return 0;
}

