/*
Liquid War is a multiplayer wargame.
Copyright (C) 2005  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War homepage : http://www.ufoot.org/liquidwar
Contact author      : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_H
#define LIQUIDWAR6GFX_H

#include "liquidwar6sys.h"

typedef struct
{
  int sym;
  int unicode;
  char *label;
}
LW6GFX_KEYPRESS;

typedef enum 
  {
    LW6GFX_MENUITEM_NONE   = 0,
    LW6GFX_MENUITEM_BUTTON = 1,
    LW6GFX_MENUITEM_EDIT   = 2,
    LW6GFX_MENUITEM_SLIDER = 3
  }
  LW6GFX_MENUITEM_TYPE;

typedef struct
{
  LW6GFX_MENUITEM_TYPE type;
  int enabled;
  int value;
  int selected_char;
  char *label;
}
  LW6GFX_MENUITEM;

typedef enum 
  {
    LW6GFX_MENU_NONE    = 0,
    LW6GFX_MENU_DEFAULT = 1,
    LW6GFX_MENU_GAME    = 2
  }
  LW6GFX_MENU_TYPE;

typedef struct
{
  LW6GFX_MENU_TYPE type;
  int selected_item;
  int nb_items;
  LW6GFX_MENUITEM *items;  
}
  LW6GFX_MENU;

/*
 * In background.c
 */
extern void lw6gfx_display_background(void *context);

/*
 * In const.c
 */
extern int lw6gfx_load_consts(void *context);
extern void lw6gfx_unload_consts(void *context);

/*
 * In data.c
 */
extern int lw6gfx_load_images(void *context);
extern void lw6gfx_unload_images(void *context);
extern int lw6gfx_load_textures(void *context);
extern void lw6gfx_unload_textures(void *context);
extern int lw6gfx_load_fonts(void *context);
extern void lw6gfx_unload_fonts(void *context);

/*
 * In event.c
 */
extern int lw6gfx_poll_keypress(void *context, LW6GFX_KEYPRESS *keypress);
extern int lw6gfx_keysym_esc(void *context);
extern int lw6gfx_keysym_up(void *context);
extern int lw6gfx_keysym_down(void *context);
extern int lw6gfx_keysym_left(void *context);
extern int lw6gfx_keysym_right(void *context);
extern int lw6gfx_keysym_enter(void *context);
extern int lw6gfx_keysym_del(void *context);
extern int lw6gfx_keysym_backspace(void *context);
extern int lw6gfx_keysym_help(void *context);
extern int lw6gfx_keysym_quit(void *context);
extern int lw6gfx_poll_quit(void *context);

/*
 * In info.c
 */
extern void lw6gfx_display_sysinfo(void *context, int fps, int rps, int bytes_in, int bytes_out);
extern void lw6gfx_display_log(void *context, char **log);

/*
 * In menu.c
 */
extern void lw6gfx_display_menu(void *context, LW6GFX_MENU *menu);

/*
 * In render.c
 */
extern void lw6gfx_prepare_buffer(void *context);
extern void lw6gfx_swap_buffers(void *context);

/*
 * In setup.c
 */
extern void *lw6gfx_init();
extern int lw6gfx_set_video_mode(void *context, int width, int height, int fullscreen);
extern void lw6gfx_quit(void *context);

/*
 * In timer.c
 */
extern void lw6gfx_delay(void *context, int ms);
extern int lw6gfx_get_ticks(void *context);






#endif
