/*
* One big, solid quad that takes up most of the map.
*
* Copyright (C) 2003, David Redick
* Released under the GNU General Public License (v2)
*/

#include <stdio.h>

#include "map.h"
#include "misc.h"

void big_quad()
{
     int vert[8];

     int width, height;

     section_size(&width, &height);

     /* left side of map */
     vert[0] = rand_num(2, width+2);
     vert[1] = rand_num(2, map.height-3);

     /* top side of map */
     vert[2] = rand_num(2, map.width-3);
     vert[3] = rand_num(2, height+2);
     
     /* right side of map */
     vert[4] = rand_num(map.width-width , map.width-3);
     vert[5] = rand_num(2, map.height-3);

     /* bottom side of map */
     vert[6] = rand_num(2, map.width-3);
     vert[7] = rand_num(map.height-height, map.height-3);

     polygon(map.map, 4, vert, 0);

return;
}
