/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* name          : lang.h                                           */
/* content       : handles language dependant stuff (locale)        */
/********************************************************************/

#ifndef LIQUID_WAR_INCLUDE_LANG
#define LIQUID_WAR_INCLUDE_LANG

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

/*==================================================================*/
/* constants                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/* Declaration of all available languages                           */
/*------------------------------------------------------------------*/

#define LW_LANG_LANGUAGE_AUTO                     -1
#define LW_LANG_LANGUAGE_ENGLISH                   0
#define LW_LANG_LANGUAGE_FRANCAIS                  1

#define LW_LANG_NB_LANGUAGES                       2

/*------------------------------------------------------------------*/
/* Declaration of all available strings                             */
/*------------------------------------------------------------------*/

#define LW_LANG_STRING_LANGUAGE                    0

#define LW_LANG_STRING_HELP_CREDITS                1
#define LW_LANG_STRING_HELP_COPYRIGHT              2
#define LW_LANG_STRING_HELP_LICENSE                3
#define LW_LANG_STRING_HELP_VERSION                4

#define LW_LANG_STRING_MENU_PLAY                   5
#define LW_LANG_STRING_MENU_NETGAME                6
#define LW_LANG_STRING_MENU_MAP                    7
#define LW_LANG_STRING_MENU_TEAMS                  8
#define LW_LANG_STRING_MENU_OPTIONS                9
#define LW_LANG_STRING_MENU_ABOUT                 10
#define LW_LANG_STRING_MENU_EXIT                  11
#define LW_LANG_STRING_MENU_EXITDOS               12
#define LW_LANG_STRING_MENU_EXITWINDOWS           13
#define LW_LANG_STRING_MENU_EXITUNIX              14
#define LW_LANG_STRING_MENU_BACK                  15

#define LW_LANG_STRING_DIALOG_QUIT                16
#define LW_LANG_STRING_DIALOG_BACK                17
#define LW_LANG_STRING_DIALOG_PLAY                18
#define LW_LANG_STRING_DIALOG_MAIN                19

#define LW_LANG_STRING_PLAY_GETREADY              20

#define LW_LANG_STRING_NETGAME_STARTGAME          21
#define LW_LANG_STRING_NETGAME_SERVERADDR         22
#define LW_LANG_STRING_NETGAME_SERVERPORT         23
#define LW_LANG_STRING_NETGAME_SEARCH             24
#define LW_LANG_STRING_NETGAME_PASSWORD           25
#define LW_LANG_STRING_NETGAME_WEAKPASSWORD       26

#define LW_LANG_STRING_LANGUAGE_AUTO              27

#define LW_LANG_STRING_TEAM_OFF                   28
#define LW_LANG_STRING_TEAM_HUMAN                 29
#define LW_LANG_STRING_TEAM_CPU                   30

#define LW_LANG_STRING_OPTIONS_GRAPHICS           31
#define LW_LANG_STRING_OPTIONS_SOUND              32
#define LW_LANG_STRING_OPTIONS_RULES              33
#define LW_LANG_STRING_OPTIONS_SPEEDS             34
#define LW_LANG_STRING_OPTIONS_CONTROLS           35
#define LW_LANG_STRING_OPTIONS_LANGUAGE           36
#define LW_LANG_STRING_OPTIONS_DEFAULT            37

#define LW_LANG_STRING_GRAPHICS_GAME              38
#define LW_LANG_STRING_GRAPHICS_MENU              39
#define LW_LANG_STRING_GRAPHICS_ON                40
#define LW_LANG_STRING_GRAPHICS_OFF               41
#define LW_LANG_STRING_GRAPHICS_FULLSCREEN        42
#define LW_LANG_STRING_GRAPHICS_WINDOWED          43
#define LW_LANG_STRING_GRAPHICS_ADVANCED          44
#define LW_LANG_STRING_GRAPHICS_VIDEOMODE         45
#define LW_LANG_STRING_GRAPHICS_BRIGHTNESS        46
#define LW_LANG_STRING_GRAPHICS_VIEWPORTSIZE      47
#define LW_LANG_STRING_GRAPHICS_PAGEFLIPPING      48
#define LW_LANG_STRING_GRAPHICS_WAVES             49

#define LW_LANG_STRING_VOLUME_SFX                 50
#define LW_LANG_STRING_VOLUME_CLICK               51
#define LW_LANG_STRING_VOLUME_GAMEWATER           52
#define LW_LANG_STRING_VOLUME_MENUWATER           53
#define LW_LANG_STRING_VOLUME_MUSIC               54

#define LW_LANG_STRING_RULES_TIME                 55
#define LW_LANG_STRING_RULES_ADVANCED             56
#define LW_LANG_STRING_RULES_ARMYSIZE             57

#define LW_LANG_STRING_ADVANCED_ATTACK            58
#define LW_LANG_STRING_ADVANCED_DEFENSE           59
#define LW_LANG_STRING_ADVANCED_BASEHEALTH        60
#define LW_LANG_STRING_ADVANCED_WINNERHELP        61
#define LW_LANG_STRING_ADVANCED_CPUSTRENGTH       62
#define LW_LANG_STRING_ADVANCED_ASMALGORITHM      63
#define LW_LANG_STRING_ADVANCED_YES               64
#define LW_LANG_STRING_ADVANCED_NO                65

#define LW_LANG_STRING_SPEEDS_CURSOR              66
#define LW_LANG_STRING_SPEEDS_FPS                 67
#define LW_LANG_STRING_SPEEDS_NOFPSLIMIT          68
#define LW_LANG_STRING_SPEEDS_RPS                 69
#define LW_LANG_STRING_SPEEDS_NORPSLIMIT          70

#define LW_LANG_STRING_CONTROLS_JOYSTICK          71          
#define LW_LANG_STRING_CONTROLS_OFF               72
#define LW_LANG_STRING_CONTROLS_2JOYSTICKS        73
#define LW_LANG_STRING_CONTROLS_4BUTTONS          74
#define LW_LANG_STRING_CONTROLS_STANDARD          75
#define LW_LANG_STRING_CONTROLS_MOUSESENSIB       76

#define LW_LANG_STRING_ABOUT_CREDITS              77
#define LW_LANG_STRING_ABOUT_COPYRIGHT            78
#define LW_LANG_STRING_ABOUT_LICENSE              79
#define LW_LANG_STRING_ABOUT_VERSION              80

#define LW_LANG_STRING_INTERNET_REFRESH           81
#define LW_LANG_STRING_INTERNET_JOINNOW           82
#define LW_LANG_STRING_INTERNET_PORT              83
#define LW_LANG_STRING_INTERNET_PASSWORD          84
#define LW_LANG_STRING_INTERNET_YES               85
#define LW_LANG_STRING_INTERNET_NO                86
#define LW_LANG_STRING_INTERNET_UPTIME            87
#define LW_LANG_STRING_INTERNET_DAYS              88
#define LW_LANG_STRING_INTERNET_DAY               89
#define LW_LANG_STRING_INTERNET_HOURS             90
#define LW_LANG_STRING_INTERNET_MINUTES           91
#define LW_LANG_STRING_INTERNET_SECONDS           92

#define LW_LANG_STRING_WAVE_AMPLI                 93
#define LW_LANG_STRING_WAVE_NUMBER                94
#define LW_LANG_STRING_WAVE_SPEED                 95
#define LW_LANG_STRING_WAVE_WX                    96
#define LW_LANG_STRING_WAVE_HY                    97
#define LW_LANG_STRING_WAVE_WY                    98
#define LW_LANG_STRING_WAVE_HX                    99

#define LW_LANG_STRING_CONNECT_STARTNOW          100
#define LW_LANG_STRING_CONNECT_WAITING           101
#define LW_LANG_STRING_CONNECT_WAITINGFOR        102
#define LW_LANG_STRING_CONNECT_TEAMS             103
#define LW_LANG_STRING_CONNECT_SENDMESSAGE       104

#define LW_LANG_STRING_NETPLAY_CONNECT           105
#define LW_LANG_STRING_NETPLAY_PING              106
#define LW_LANG_STRING_NETPLAY_CHECKPROGRAM      107
#define LW_LANG_STRING_NETPLAY_CHECKVERSION      108
#define LW_LANG_STRING_NETPLAY_SENDPASSWORD      109
#define LW_LANG_STRING_NETPLAY_FREETEAMS         110
#define LW_LANG_STRING_NETPLAY_RESERVETEAMS      111
#define LW_LANG_STRING_NETPLAY_SENDCONFIG        112
#define LW_LANG_STRING_NETPLAY_SENDMAP           113
#define LW_LANG_STRING_NETPLAY_WAITING           114
#define LW_LANG_STRING_NETPLAY_WHOPLAYS          115
#define LW_LANG_STRING_NETPLAY_RECVCONFIG        116
#define LW_LANG_STRING_NETPLAY_RECVMAP           117

#define LW_LANG_STRING_CODE_FPS                  118
#define LW_LANG_STRING_CODE_RPS                  119
#define LW_LANG_STRING_CODE_PERCENTCALC          120
#define LW_LANG_STRING_CODE_PERCENTDISPLAY       121
#define LW_LANG_STRING_CODE_SPREADGRADTIME       122
#define LW_LANG_STRING_CODE_MOVEARMYTIME         123
#define LW_LANG_STRING_CODE_DISPLAYTIME          124
#define LW_LANG_STRING_CODE_FLIPTIME             125
#define LW_LANG_STRING_CODE_OTHERCALCTIME        126
#define LW_LANG_STRING_CODE_GLOBALTIME           127
#define LW_LANG_STRING_CODE_STANDARDDISPLAY      128
#define LW_LANG_STRING_CODE_GRADIENT1            129
#define LW_LANG_STRING_CODE_GRADIENT2            130
#define LW_LANG_STRING_CODE_GRADIENT3            131
#define LW_LANG_STRING_CODE_GRADIENT4            132
#define LW_LANG_STRING_CODE_GRADIENT5            133
#define LW_LANG_STRING_CODE_GRADIENT6            134
#define LW_LANG_STRING_CODE_MESHSIZE             135
#define LW_LANG_STRING_CODE_MESHSTRUCTURE        136
#define LW_LANG_STRING_CODE_PAUSEOFF             137
#define LW_LANG_STRING_CODE_PAUSEON              138
#define LW_LANG_STRING_CODE_WAVEEFFECTSOFF       139
#define LW_LANG_STRING_CODE_WAVEEFFECTSON        140
#define LW_LANG_STRING_CODE_CAPTUREOFF           141
#define LW_LANG_STRING_CODE_CAPTUREON            142

#define LW_LANG_STRING_SCORE_WINNER              143

#define LW_LANG_STRING_GAME_BACKMEMFAIL          144
#define LW_LANG_STRING_GAME_DISPMEMFAIL          145
#define LW_LANG_STRING_GAME_MESHMEMFAIL          146
#define LW_LANG_STRING_GAME_AREAMEMFAIL          147
#define LW_LANG_STRING_GAME_ARMYMEMFAIL          148

#define LW_LANG_STRING_ERROR_NOTENOUGHTEAMS      149
#define LW_LANG_STRING_ERROR_NOTENOUGHBIGDATA    150
#define LW_LANG_STRING_ERROR_GRAPHICSINITFAILED  151
#define LW_LANG_STRING_ERROR_NONETWORKSUPPORT    152
#define LW_LANG_STRING_ERROR_UNABLETOCONNECT     153
#define LW_LANG_STRING_ERROR_NOTALIQUIDWARSERVER 154 
#define LW_LANG_STRING_ERROR_WRONGVERSION        155
#define LW_LANG_STRING_ERROR_NETWORKPROBLEM      156
#define LW_LANG_STRING_ERROR_CANTSENDMAP         157
#define LW_LANG_STRING_ERROR_CANTRECEIVEMAP      158
#define LW_LANG_STRING_ERROR_SERVERFULL          159
#define LW_LANG_STRING_ERROR_BADPASSWORD         160

#define LW_LANG_NB_STRINGS                       161

/*==================================================================*/
/* globals                                                          */
/*==================================================================*/

/*==================================================================*/
/* functions                                                        */
/*==================================================================*/

extern void lw_lang_init();
extern char *lw_lang_string(int id);
extern char *lw_lang_language(int lang);
extern int lw_lang_auto();

#endif
