/********************************************************************/
/*                                                                  */
/*            L   I  QQ  U U I DD    W   W  A  RR    555            */
/*            L   I Q  Q U U I D D   W   W A A R R   5              */
/*            L   I Q  Q U U I D D   W W W AAA RR    55             */
/*            L   I Q Q  U U I D D   WW WW A A R R     5            */
/*            LLL I  Q Q  U  I DD    W   W A A R R   55             */
/*                                                                  */
/*                             b                                    */
/*                             bb  y y                              */
/*                             b b yyy                              */
/*                             bb    y                              */
/*                                 yy                               */
/*                                                                  */
/*                     U U       FFF  O   O  TTT                    */
/*                     U U       F   O O O O  T                     */
/*                     U U TIRET FF  O O O O  T                     */
/*                     U U       F   O O O O  T                     */
/*                      U        F    O   O   T                     */
/*                                                                  */
/********************************************************************/

/*****************************************************************************/
/* Liquid War is a unique multiplayer wargame                                */
/* Copyright (C) 1998-2002 Christian Mauduit                                 */
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*                                                                           */
/* Liquid War homepage : http://www.ufoot.org/liquidwar                      */
/* Contact author      : ufoot@ufoot.org                                     */
/*****************************************************************************/

/********************************************************************/
/* nom           : netplay.c                                        */
/* content       : function which launches a network game           */
/********************************************************************/

/*==================================================================*/
/* includes                                                         */
/*==================================================================*/

#include <string.h>

#include "back.h"
#include "base.h"
#include "config.h"
#include "decal.h"
#include "dialog.h"
#include "help.h"
#include "menu.h"
#include "play.h"
#include "disk.h"
#include "protocol.h"
#include "sockgen.h"
#include "server.h"
#include "network.h"
#include "keyexch.h"
#include "error.h"
#include "internet.h"
#include "netplay.h"
#include "lang.h"
#include "log.h"
#include "connect.h"

/*==================================================================*/
/* variables globales                                               */
/*==================================================================*/

/*==================================================================*/
/* static functions                                                 */
/*==================================================================*/

static int connect_on_server_start(int *sock, char *ip, int port);
static int connect_on_server_finish(int sock);

/*==================================================================*/
/* fonctions                                                        */
/*==================================================================*/

/*------------------------------------------------------------------*/
/*
 * The equivalent of play_sequence, but for a network game.
 * Basically, this is the function called when you press "play" 
 * to launch a network game.
 */
int netplay_sequence()
{
  int sock=-1;
  int result=0;

  if (connect_on_server_start(&sock,
			      CONFIG_SERVER_ADDRESS,
			      CONFIG_SERVER_PORT))
    {
      result=lw_connect_menu(sock);

      if (result==MENU_OK)
	{
	  if (connect_on_server_finish(sock))
	    {
	      LW_NETWORK_ON=1;
	      lw_network_attribute_colors();
	      lw_network_attribute_parts();
	      result=play_sequence ();
	      LW_NETWORK_ON=0;
	    }
	}
    }

  LW_KEYEXCH_SOCK=-1;
  lw_sock_close(&sock);

  return result;
}

/*------------------------------------------------------------------*/
/*
 * Opens the socket on the server, sends some messages to the server,
 * and displays message boxes to the player so that he has an idea
 * of what's going on.
 */
static int connect_on_server_start(int *sock, char *address, int port)
{
  int result=1;
  int free_teams;
  //  int waited_teams;
  int i;

  (*sock)=-1;

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_CONNECT));
      if (!lw_sock_connect(sock,address,port))
	{
	  result=0;
	  error_unable_to_connect();
	}
    }
  
  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_PING));
      if (!lw_protocol_do_ping(*sock))
	{
	  result=0;
	  error_not_a_liquidwar_server();
	}
    }

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_CHECKPROGRAM));
      if (!lw_protocol_tell_program(*sock,LW_PROGRAM))
	{
	  result=0;
	  error_not_a_liquidwar_server();
	}
    }
  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_CHECKVERSION));
      if (!lw_protocol_tell_version(*sock,LW_VERSION))
	{
	  result=0;
	  error_wrong_version();
	}
    }

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_FREETEAMS));
      if (lw_protocol_ask_free_teams(*sock,&free_teams))
	{
	  if (free_teams<=0)
	    {
	      result=0;
	      error_server_full();
	    }
	}
      else
	{
	  result=0;
	  error_network_problem();
	}
    }

  if (result==1) 
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_RESERVETEAMS));
      for (i=0;i<NB_TEAMS && free_teams>0 && result==1;++i)
	{
	  if (CONFIG_CONTROL_TYPE[i] != CONFIG_CONTROL_TYPE_OFF)
	    {
	      if (lw_protocol_reserve_team(*sock,i,CONFIG_PLAYER_NAME[i]))
		{
		  free_teams--;
		}
	      else
		{
		  result=0;
		  error_network_problem();
		}
	    }
	}
    }

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_SENDCONFIG));
      if (!lw_protocol_send_config
	  (*sock))
	{
	  result=0;
	  error_network_problem();
	}
    }

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_SENDMAP));
      if (!lw_protocol_send_map
	  (*sock,RAW_MAP_ORDERED[CONFIG_LEVEL_MAP]))
	{
	  result=0;
	  error_cant_send_map();
	}
    }

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_WAITING));
      if (!lw_protocol_i_am_ready(*sock))
	{
	  result=0;
	  error_network_problem();
	}
    }

  /*
   * if the operation succeded, we set the global value LW_KEYEXCH_SOCK
   * to the right socket, otherwise functions from lw_keyech won't work...
   */
  if (result)
    {
      LW_KEYEXCH_SOCK=*sock;
    }
  else
    {
      LW_KEYEXCH_SOCK=-1;
      lw_sock_close(sock);
    }
  
  return result;
}

/*------------------------------------------------------------------*/
/*
 * Retrieves informations from the server once all players are
 * connected. Also displays information in a dialog box.
 */
static int connect_on_server_finish(int sock)
{
  int result=1;
  int i;

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_WHOPLAYS));
      for (i=0;i<NB_TEAMS && result==1;++i)
	{
	  if (!lw_protocol_ask_who
	      (sock,i,&(LW_NETWORK_INFO[i])))
	    {
	      result=0;
	      error_network_problem();
	    }
	}
    }  

  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_RECVCONFIG));
      if (!lw_protocol_recv_config
	  (sock))
	{
	  result=0;
	  error_network_problem();
	}
    }
  
  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_RECVMAP));
      if (!lw_protocol_recv_map
	  (sock,&LW_NETWORK_RAW_MAP))
	{
	  result=0;
	  error_cant_receive_map();
	}
    }
  
  if (result==1)
    {
      display_center_message (lw_lang_string(LW_LANG_STRING_NETPLAY_WAITING));
      if (!lw_protocol_i_am_ready(sock))
	{
	  result=0;
	  error_network_problem();
	}
    }

  /*
   * We close the socket if something failed
   */
  if (!result)
    {
      LW_KEYEXCH_SOCK=-1;
      lw_sock_close(&sock);
    }
  
  return result;
}
